#include "../baseclasses/CString.h"
#include "../baseclasses/CException.h"
#include "../baseclasses/CMd5.h"
#include "../baseclasses/CArray.h"
#include "../baseclasses/CConfig.h"
#include "../baseclasses/CMultipartForm.h"
#include "../baseclasses/CTime.h"
#include "printpage.h"
#include "ExpireFiles.h"
#include "RemakeIndex.h"
#include "CheckLoadAverage.h"
#include "GetInterval.h"
#include "CUploadedFiles.h"
#include "UploadFileCheck.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <dirent.h>
#include <locale.h>
#include <unistd.h>
#include <libgen.h>
#include <netdb.h>
#include <signal.h>

#include <regex.h>	// oh, it's stupid way..

#define	BUFFERSIZE	32768

void SigPipeHandler(int Parm)
{
// O𓊂ď𒆒f
throw(CException(CException::CErrorTypeException, CException::CAborted, "SigPipeHandler"));
}

int main(int args, char *argv[])
{
CConfig Config;
CString SubTitle;
CMultipartForm Form;
int Length;
char *RemoteAddr;
char argvcopy[PATH_MAX];
sighandler_t OldHandler;
CString SourceFileNamePath, ThreadFilePath;

// VOinhZbg
if ((OldHandler=signal(SIGPIPE, (sighandler_t)(&SigPipeHandler))) == SIG_ERR)
	{
	printf("Content-Type: text/plain\r\n\r\n");
	printf("VOinh̐ݒɎs܂B\r\n");
	return 0;
	}

// ݒǂݍ
try	{
	Config.Open("config.cgi");
	setlocale(LC_ALL, (const char *)Config.GetItemValue("Locale"));
	} catch (CException& e)
		{
		printf("Content-Type: text/plain\r\n\r\n");
		printf("ݒt@Cǂ݂Ƃ܂BǗ҂ɘAĂB\r\n");
		return 0;
		}

// ݂̃fBNgcgĩfBNgɈڂ
strncpy(argvcopy, argv[0], PATH_MAX);
argvcopy[PATH_MAX-1]=0;
if (chdir(dirname(argvcopy)) != 0)
	{
	printf("Content-Type: text/plain\r\n\r\n");
	printf("fBNgړł܂łBǗ҂ɘAĂB\r\n");
	return 0;
	}

// ϐ REMOTE_ADDR ͕K{
if (getenv("REMOTE_ADDR") == NULL)
	{
	printf("Content-Type: text/plain\r\n\r\n");
	printf("ϐ REMOTE_ADDR ݒ肳Ă܂BǗ҂ɘAĂB\r\n");
	return 0;
	}
RemoteAddr=getenv("REMOTE_ADDR");

// tH[ɋLς݂Ȃ΃fR[h
Length=0;
if (getenv("CONTENT_LENGTH") != NULL)
	{
	try	{
		Length=atoi(getenv("CONTENT_LENGTH"));
		Form.Open(stdin, Length);
		} catch (CException& e)
			{
			printf("Content-Type: text/plain\r\n\r\n");
			printf("tH[f[^ǂ݂Ƃ܂łBǗ҂ɘAĂB\r\n");
			return 0;
			}
	}

// httpwb_
printf("Content-Type: text/html; charset=\"shift_jis\"\r\n\r\n");

try	{
	int unsigned UploadMinSize, UploadMaxSize;
	int unsigned FileLength;
	int unsigned TimeSeed;
	FILE *hTmp, *hFile;
	CString UploadDir, SourceFileName;
	CString SourceFileNameExt;
	DIR *dir;
	char unsigned *buffer;
	int unsigned LeftSize, ReadSize;
	CMd5 Md5;
	CString Passphrase, PassEncoded;
	long int unsigned Interval, MinInterval;
	CUploadedFiles Files;
	CString CommentStr;
	CTime CurrentTime;
	CString ServerName, URI, URL;
	CString Str, Str2, HostName;
	int i;
	struct hostent *hst;
	in_addr_t ia;

	// ݎݒ肷
	CurrentTime.SetDateAndTimeLocalCurrent();

	// y[W̖`o
	SubTitle="Abv[h";
	PrintPageBeginning(stdout, Config, SubTitle);

	// CfbNXy[W֖߂郊No
	printf("<p align=\"center\"> <a href=\"..\"> ꗗɖ߂ </a> </p>\r\n");
	fflush(stdout);

	// Abv[hۃXgɌfڂĂȂH
	i=1;

	// gethost
	ia=inet_addr(getenv("REMOTE_ADDR"));	// not null
	hst=gethostbyaddr((const char *)(&ia),
		sizeof(in_addr_t), AF_INET);
	if (hst == NULL)
		HostName=(const char *)getenv("REMOTE_ADDR");
	else	HostName=hst->h_name;
	while (-1)
		{
		Str.Format("UploadDenyHost%i", i);
		if (Config.IsExistItemName(Str) == 0) break;
		Str2=Config.GetItemValue(Str);
		
		if (Str2.Find('/') >= 0)
			{
			// IPaddr/subnet
			in_addr_t addr1, addr2, netmask;
			CString Str3;
			int i;
			
			addr1=inet_addr(getenv("REMOTE_ADDR"));
			addr2=inet_addr((const char *)(Str2.Left(Str2.Find('/'))));
			Str3=Str2.Mid(Str2.Find('/')+1);
			if (Str3.Find('.') >= 0)
				netmask=inet_addr((const char *)Str3);
			else	{
				netmask=0;
				for(i=0;i<atoi((const char *)Str3);i++)
					netmask|=(1 << (31-i));
				netmask=htonl(netmask);
				}

			if ((addr1&netmask) == (addr2&netmask))
				{
				// }b`
				printf("\t<p> <font color=\"%s\"> <b> Abv[h֎~ĂzXgł (%s)B </b> </font> </p> \r\n",
					(const char *)Config.GetItemValue("ErrorTextColor"),
					(const char *)HostName);

				throw(CException(CException::CErrorTypeException,
					CException::CIllegalStatus, "UploadFormCgi"));
				}
			}
		else	{
			regex_t reg;
			int ret;

			// host based denying (w. regex)
			if ((ret=regcomp(&reg, (const char *)Str2, REG_ICASE)) != 0)
				throw(CException(CException::CErrorTypeRegExpError,
					ret, (void *)(&reg), "UploadFormCgi"));

			if (regexec(&reg, (const char *)HostName, 0, NULL, 0) == 0)
				{
				regfree(&reg);

				// }b`
				printf("\t<p> <font color=\"%s\"> <b> Abv[h֎~ĂzXgł (%s)B </b> </font> </p> \r\n",
					(const char *)Config.GetItemValue("ErrorTextColor"),
					(const char *)HostName);

				throw(CException(CException::CErrorTypeException,
					CException::CIllegalStatus, "UploadFormCgi"));
				}
			
			regfree(&reg);
			}
		i++;
		}

	// `
	printf("<ul>\r\n");
	printf("\t<li> tH[f[^ (%i oCg) MAe߂܂B </li> \r\n", Length);
	fflush(stdout);

	// ŒAbv[hԊuĂȂH
	MinInterval=atol(Config.GetItemValue("MinIntervalUpload"));
	if ((Interval=GetIntervalIpV4(1, 1, inet_addr(RemoteAddr),
		MinInterval)) < MinInterval)
		{
		printf("\t<p> <font color=\"%s\"> <b> ÕAbv[h %i boĂ܂BȂƂ %i b҂ĂAbv[hĂB </b> </font> </p> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"),
			Interval, (int)MinInterval);

		throw(CException(CException::CErrorTypeException,
			CException::CIllegalStatus, "UploadCgi"));
		}

	// [hAx[W߂ĂȂH
	if (CheckLoadAverage(1, Config) != 1)
		{
		printf("\t<li> <font color=\"%s\"> <b> T[oߕ׏ԂłBAbv[h͒f܂B </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		throw(CException(CException::CErrorTypeException,
			CException::CIllegalStatus, "UploadCgi"));
		}

	// tH[ACeMłǂ𒲂ׂ
	if ((Form.IsExistFormItem("filedata") != 1)
		||(Form.IsExistFormItem("comment") != 1)
		||(Form.IsExistFormItem("deletepassword") != 1))
		{
		// ACes
		printf("\t<li> <font color=\"%s\"> <b> tH[f[^sĂ܂B </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		throw(CException(CException::CErrorTypeException,
			CException::CIllegalParameter, "UploadCgi"));
		}

	// Abv[h̃fBNg݂Ă邱ƂmF
	UploadDir.Format("../%s", (const char *)Config.GetItemValue("UploadSourceDir"));
	dir=opendir((const char *)UploadDir);
	if (dir == NULL)
		{
		int unsigned lasterrno;

		// fBNg݂Ȃ
		lasterrno=errno;
		printf("\t<li> <font color=\"%s\"> <b> Abv[h̃fBNg݂ȂAANZXł܂B </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		throw(CException(CException::CErrorTypeErrorCode,
			lasterrno, "UploadCgi"));
		}
	closedir(dir);

	// ő^ŏt@CTCY擾
	UploadMaxSize=atoi(Config.GetItemValue("UploadMaxSize"));
	UploadMinSize=atoi(Config.GetItemValue("UploadMinSize"));

	// Mt@CTCY͈͓ɂ邩ǂmF
	try	{
		FileLength=Form.GetFormItem("filedata").End-Form.GetFormItem("filedata").Begin;
		} catch (CException& e)
			{
			FileLength=0;	// 0 byte 
			}
	if ((FileLength < UploadMinSize)||(FileLength > UploadMaxSize))
		{
		printf("\t<li> <font color=\"%s\"> <b> Abv[ht@C̃TCY (%u oCg) ꂽ͈(%u oCg` %u oCg)ɂ܂B </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"),
			FileLength, UploadMinSize, UploadMaxSize);
		printf("</ul>\r\n");

		throw(CException(CException::CErrorTypeException,
			CException::CIllegalParameter, "UploadCgi"));
		}

	// t@C𐶐
	SourceFileNameExt=Config.GetItemValue("UploadFileDefaultExtension");
	if (Form.GetFormItem("filedata").IsExistHeader("Content-Disposition") == 1)
		{
		CString Value;

		Value=Form.GetFormItem("filedata").GetHeaderValue("Content-Disposition");
		if (Value.Find("filename=") >= 0)
			{
			int i;
			int Pos1, Pos2;
			CString FileNameTmp;
			CString Name, Value2;

			// t@Co
			Pos1=Value.Find("filename=")+9;
			Pos2=Value.Find(';', Pos1);
			if (Pos2 >= 0)
				FileNameTmp=Value.Mid(Pos1, Pos2-Pos1);
			else	FileNameTmp=Value.Mid(Pos1);
			if ((FileNameTmp[0] == '\"')
				&&(FileNameTmp[FileNameTmp.Length-1] == '\"'))
				FileNameTmp=FileNameTmp.Mid(1, FileNameTmp.Length-2);

			// gqo
			if (FileNameTmp.Find('.', FileNameTmp.Length-1, 1, -1) >= 0)
				SourceFileNameExt=FileNameTmp.Mid(FileNameTmp.Find('.', FileNameTmp.Length-1, 1, -1)+1);

			// gq̃oCg
			if (SourceFileNameExt.Length > atoi((const char *)Config.GetItemValue("UploadFileExtensionMaxLength")))
				SourceFileNameExt=SourceFileNameExt.Left(atoi((const char *)Config.GetItemValue("UploadFileExtensionMaxLength")));

			// SJIS̒fЂƕ\s\ȕr
			for(i=0;i<SourceFileNameExt.Length;i++)
				{
				if (isprint((char unsigned)(SourceFileNameExt[i])) == 0)
					SourceFileNameExt.Delete(i);
				else if ((char unsigned)(SourceFileNameExt[i]) >= 0x80)
					SourceFileNameExt.Delete(i);
				}

			// tB^ׂgqɈvĂ邩ǂ
			i=1;
			while (-1)
				{
				Name.Format("UploadFilterFileExtension%i", i);
				if (Config.IsExistItemName(Name) != 1) break; // l̗񋓂I

				// gq̈v`FbN
				Value2=Config.GetItemValue(Name);
				if (SourceFileNameExt == Value2)
					{
					// gqftHĝ̂ɕύXďI
					SourceFileNameExt=Config.GetItemValue("UploadFileDefaultExtension");
					break;
					}

				i++;	// 
				}

			// gqݒȂ΃ftHg
			if (SourceFileNameExt.Length < 1)
				SourceFileNameExt=Config.GetItemValue("UploadFileDefaultExtension");
			}
		}

	TimeSeed=(time_t)CurrentTime;
	do	{	// t@CdȂƂ̃`FbN
		SourceFileName.Format("%u.%s",
			TimeSeed, (const char *)SourceFileNameExt);
		SourceFileNamePath.Format("%s/%s",
			(const char *)UploadDir,
			(const char *)SourceFileName);
		hTmp=fopen((const char *)SourceFileNamePath, "rb");
		if (hTmp == NULL) break;
		fclose(hTmp);
		TimeSeed++;
		} while (-1);
	if (errno != ENOENT)
		{
		int unsigned lasterrno;

		lasterrno=errno;
		printf("\t<li> <font color=\"%s\"> <b> Abv[hƂĐݒ肵fBNgǂ݂Ƃ邱Ƃł܂łB </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		throw(CException(CException::CErrorTypeErrorCode, lasterrno, "UploadCgi"));
		}
	printf("\t<li> t@C &quot;%s&quot; œo^sȂ܂B </li> \r\n",
		(const char *)SourceFileName);
	fflush(stdout);

	// obt@蓖Ă
	buffer=(char unsigned *)malloc(BUFFERSIZE);
	if (buffer == NULL)
		{
		int unsigned lasterrno;

		lasterrno=errno;
		printf("\t<li> <font color=\"%s\"> <b> obt@蓖Ă܂łB </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		throw(CException(CException::CErrorTypeErrorCode, lasterrno, "UploadCgi"));
		}

	// t@Co^
	hFile=fopen(SourceFileNamePath, "wb");
	if (hFile == NULL)
		{
		int unsigned lasterrno;

		lasterrno=errno;
		printf("\t<li> <font color=\"%s\"> <b> t@CނƂł܂łB </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		free(buffer);
		throw(CException(CException::CErrorTypeErrorCode,
			lasterrno, "UploadCgi"));
		}

	// t@C{̂
	hTmp=Form.hTmpFile;
	fseek(hTmp, Form.GetFormItem("filedata").Begin, SEEK_SET);
	LeftSize=Form.GetFormItem("filedata").End-Form.GetFormItem("filedata").Begin;
	printf("\t<li> %u oCgt@CƂĎM܂B </li> \r\n",
		LeftSize);
	fflush(stdout);
	Md5.Init();
	while (LeftSize > 0)
		{
		ReadSize=fread((void *)buffer, 1, min(LeftSize, BUFFERSIZE), hTmp);
		fwrite((void *)buffer, ReadSize, 1, hFile);
		Md5.Update((char unsigned *)buffer, ReadSize);
		LeftSize-=ReadSize;
		}
	Md5.Finish();
	fclose(hFile);

	// t@C`FbNiɃECXړIj
	if (UploadFileCheck(Config, SourceFileNamePath) != 0)
		{
		printf("\t<li> <font color=\"%s\"> <b> Abv[ht@C̓t@C`FbJ[ɂċۂ܂B </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		free(buffer);
		unlink((const char *)SourceFileNamePath);
		throw(CException(CException::CErrorTypeException,
			CException::CIllegalParameter, "UploadCgi"));
		}

	// MD5_CWFXglɑ݂Ă̂ǂ
	{
	int i;
	CString Value1, Value2;

	Files.Open(UploadDir);
	Value2=(CString)Md5;
	for(i=0;i<Files.Items.Size;i++)
		{
		Value1=Files.Items[i].GetMd5String();
		if (Value1 == Value2)
			{
			// t@Cɓo^ς݂
			printf("\t<li> <font color=\"%s\"> <b> ɓ̃t@Co^ς݂łB </b> </font> </li> \r\n",
				(const char *)Config.GetItemValue("ErrorTextColor"));
			printf("</ul>\r\n");

			free(buffer);
			unlink((const char *)SourceFileNamePath);
			throw(CException(CException::CErrorTypeException,
				CException::CIllegalParameter, "UploadCgi"));
			}
		}
	Files.Items.RemoveAll();
	}

	// MD5_CWFXgl
	hFile=fopen(SourceFileNamePath+".md5", "wb");
	if (hFile == NULL)
		{
		int unsigned lasterrno;

		lasterrno=errno;
		printf("\t<li> <font color=\"%s\"> <b> t@CނƂł܂łB </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		free(buffer);
		unlink((const char *)SourceFileNamePath);
		throw(CException(CException::CErrorTypeErrorCode,
			lasterrno, "UploadCgi"));
		}
	fprintf(hFile, "%s", (const char *)(CString)Md5);
	fclose(hFile);

	// Rgt@C
	hFile=fopen(SourceFileNamePath+".txt", "wt");
	if (hFile == NULL)
		{
		int unsigned lasterrno;

		lasterrno=errno;
		printf("\t<li> <font color=\"%s\"> <b> t@CނƂł܂łB </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		free(buffer);
		unlink((const char *)SourceFileNamePath);
		unlink((const char *)(SourceFileNamePath+".md5"));
		throw(CException(CException::CErrorTypeErrorCode,
			lasterrno, "UploadCgi"));
		}

	hTmp=Form.hTmpFile;
	fseek(hTmp, Form.GetFormItem("comment").Begin, SEEK_SET);
	LeftSize=Form.GetFormItem("comment").End-Form.GetFormItem("comment").Begin;
	printf("\t<li> %u oCgRgƂĎM܂B </li> \r\n",
		LeftSize);
	fflush(stdout);
	CommentStr.Empty();
	while (LeftSize > 0)
		{
		CString Str, Str2;

		ReadSize=fread((void *)buffer, 1, min(LeftSize, BUFFERSIZE), hTmp);
		Str.Empty();
		Str.Insert(0, (char *)buffer, ReadSize, 1);
		Str2=Str.EncodeIllegalHtmlChar();
		CommentStr+=Str2;
		fwrite((void *)(const char *)Str2, Str2.Length, 1, hFile);
		LeftSize-=ReadSize;
		}
	fclose(hFile);

	// V[Nbgt@C
	hFile=fopen(SourceFileNamePath+".cgi", "wt");
	if (hFile == NULL)
		{
		int unsigned lasterrno;

		lasterrno=errno;
		printf("\t<li> <font color=\"%s\"> <b> t@CނƂł܂łB </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		free(buffer);
		unlink((const char *)SourceFileNamePath);
		unlink((const char *)(SourceFileNamePath+".md5"));
		unlink((const char *)(SourceFileNamePath+".txt"));
		throw(CException(CException::CErrorTypeErrorCode,
			lasterrno, "UploadCgi"));
		}

	// pX[hǂݏo
	Passphrase=Form.GetFormItemValue("deletepassword");
	printf("\t<li> %u oCg폜pX[hƂĎM܂B </li> \r\n",
		LeftSize);
	fflush(stdout);

	// pX[h(MD5)
	PassEncoded.Format((const char *)Config.GetItemValue("PasswordFormatString"), (const char *)Passphrase);
	Md5.Init();
	Md5.Update((char unsigned *)(const char *)PassEncoded, PassEncoded.Length);
	Md5.Finish();
	fprintf(hFile, "DELETEPASSWORD_MD5=%s\n", (const char *)(CString)Md5);
	Passphrase.Empty();
	PassEncoded.Empty();
	// IP
	fprintf(hFile, "IP=%s\n", RemoteAddr);
	// USER_AGENT
	if (getenv("HTTP_USER_AGENT") != NULL)
		fprintf(hFile, "USER_AGENT=%s\n", getenv("HTTP_USER_AGENT"));
	else	fprintf(hFile, "USER_AGENT=(NULL)\n");
	// AUTODELETETIME
	if ((Config.IsExistItemName("EnableAutoDelete") == 1)
		&&(atoi(Config.GetItemValue("EnableAutoDelete")) == 1))
		{
		if ((Form.IsExistFormItem("autodelete_hour") == 1)
			&&(Form.GetFormItemValue("autodelete_hour").Length > 0))
			{
			CTime AutoDeleteTime;

			AutoDeleteTime.SetDateAndTimeLocalCurrent();
			AutoDeleteTime.AddHour(atoi(Form.GetFormItemValue("autodelete_hour")));
			fprintf(hFile, "AUTODELETETIME=%04i/%02i/%02i %02i:%02i:%02i\n",
				AutoDeleteTime.Year, AutoDeleteTime.Month, AutoDeleteTime.Day,
				AutoDeleteTime.Hour, AutoDeleteTime.Minute, AutoDeleteTime.Second);
			}
		}
	fclose(hFile);

	free(buffer);

	// Q˂uEUpXbh쐬
	ThreadFilePath.Format("../board/dat/%i.dat", TimeSeed);
	hFile=fopen(ThreadFilePath, "wt");
	if (hFile == NULL)
		{
		int unsigned lasterrno;

		lasterrno=errno;
		printf("\t<li> <font color=\"%s\"> <b> t@CނƂł܂łB </b> </font> </li> \r\n",
			(const char *)Config.GetItemValue("ErrorTextColor"));
		printf("</ul>\r\n");

		free(buffer);
		unlink((const char *)SourceFileNamePath);
		unlink((const char *)(SourceFileNamePath+".cgi"));
		unlink((const char *)(SourceFileNamePath+".md5"));
		unlink((const char *)(SourceFileNamePath+".txt"));
		throw(CException(CException::CErrorTypeErrorCode,
			lasterrno, "UploadCgi"));
		}
	Md5.Init();
	Md5.Update((char unsigned *)RemoteAddr, strlen(RemoteAddr));
	Md5.Update((char unsigned *)(&CurrentTime.Year), sizeof(CurrentTime.Year));
	Md5.Update((char unsigned *)(&CurrentTime.Month), sizeof(CurrentTime.Month));
	Md5.Update((char unsigned *)(&CurrentTime.Day), sizeof(CurrentTime.Day));
	Md5.Finish();

	if (getenv("SERVER_NAME") != NULL)
		ServerName=getenv("SERVER_NAME");
	else	ServerName="localhost";

	if (getenv("REQUEST_URI") != NULL)
		{
		URI=getenv("REQUEST_URI");
		if (URI.Find('/', URI.Length-1, 1, -1) > 0)
			URI=URI.Left(URI.Find('/', URI.Length-1, 1, -1));
		}
	else	URI.Empty();

	URL.Format("http://%s%s/%s/%s",
		(const char *)ServerName, (const char *)URI, (const char *)UploadDir, (const char *)SourceFileName);
	fprintf(hFile, "1<><>%04i/%02i/%02i %02i:%02i:%02i ID:%8.8s<><br>%s<br><a href=\"%s\">%s</a> <>%s\n",
		CurrentTime.Year, CurrentTime.Month, CurrentTime.Day,
		CurrentTime.Hour, CurrentTime.Minute, CurrentTime.Second,
		(const char *)(Md5.ToMimeString()), (const char *)CommentStr,
		(const char *)URL, (const char *)URL, (const char *)CommentStr);
	fclose(hFile);

	// Ât@C폜
	printf("\t<li> Ât@C폜Ă܂B </li> \r\n");
	fflush(stdout);
	ExpireFiles(Config, UploadDir);

	// CfbNXč쐬
	printf("\t<li> CfbNXč쐬Ă܂B </li> \r\n");
	fflush(stdout);
	RemakeIndex(Config, UploadDir);

	// I
	printf("\t<li> <font color=\"%s\"> <b> SĂ̏ɏI܂B </b> </font> </li> \r\n",
		(const char *)Config.GetItemValue("SuccessfulTextColor"));
	printf("</ul>\r\n");
	fflush(stdout);
	} catch (CException& e)
		{
		printf("<p> G[܂Bvꂽ̓LZ܂B </p> \r\n");
		if (atoi((const char *)Config.GetItemValue("ShowDebugMessage")) > 0)
			printf("<p> %s @ %s </p>",
				(const char *)e.GetErrorMessage(), (const char *)e.GetErrorPosition());

		// c[̃t@C폜
		if (SourceFileNamePath.Length > 0)
			{
			unlink((const char *)SourceFileNamePath);
			unlink((const char *)(SourceFileNamePath+".cgi"));
			unlink((const char *)(SourceFileNamePath+".md5"));
			unlink((const char *)(SourceFileNamePath+".txt"));
			}
		if (ThreadFilePath.Length > 0)
			unlink((const char *)ThreadFilePath);
		}

// CfbNXy[W֖߂郊No
printf("<p align=\"center\"> <a href=\"..\"> ꗗɖ߂ </a> </p>\r\n");
fflush(stdout);

// y[W̏Io
PrintPageEnding(stdout, Config);

// VOinhɖ߂
signal(SIGPIPE, OldHandler);

return 0;
}
