#include "../baseclasses/CString.h"
#include "../baseclasses/CException.h"
#include "../baseclasses/CMd5.h"
#include "../baseclasses/CArray.h"
#include "../baseclasses/CConfig.h"
#include "../baseclasses/CQueryString.h"
#include "printpage.h"
#include "ExpireFiles.h"
#include "RemakeIndex.h"
#include "CheckLoadAverage.h"
#include "GetInterval.h"
#include "CUploadedFiles.h"
#include "UploadFileCheck.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <dirent.h>
#include <locale.h>
#include <fcntl.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <libgen.h>

#define	BUFFERSIZE	32768

CString ReadFileLine(FILE *hFile, int MaxLength);

void BbsCgiErrorOut(CString ErrorMessage, CString Name, CString MailAddress, CString MessageText)
{
printf("Content-Type: text/html; charset=\"shift_jis\"\r\n\r\n");
printf("<html>\n");
printf("<head>\n");
printf("<title>dqqnqI</title>\n");
printf("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Shift_JIS\">\n");
printf("</head>\n");
printf("<body bgcolor=\"#FFFFFF\">\n");
printf("<font size=+1 color=#FF0000><b>dqqnqF%s</b></font><ul>\n", (const char *)ErrorMessage);
printf("<b> </b><br>\n");
printf("OF %s<br>\n", (const char *)Name);
printf("E-mailF %s<br>\n", (const char *)MailAddress);
printf("eF<br>%s<br>\n\n", (const char *)MessageText);
printf("</ul><center>Ń[hĂB<a href=\"../\"> GO! </a><br>\n\n");
printf("</body>\n");
printf("</html>\n");
}

int main(int args, char *argv[])
{
CConfig Config;
CQueryString Query;
int Length;
char *RemoteAddr;
int i, j;
FILE *hDatFile;
CString FileNamePath, String;
struct stat st;
struct flock lock;
CString Src, MessageText, From, Mail, IdHostString;
CTime CurrentTime;
int ThreadKey, BoardShowHostMode;
int Lines;
int ErrorOutFlag;
char argvcopy[PATH_MAX];

// ݒǂݍ
try	{
	Config.Open("config.cgi");
	setlocale(LC_ALL, (const char *)Config.GetItemValue("Locale"));
	} catch (CException& e)
		{
		printf("Content-Type: text/plain\r\n\r\n");
		printf("ݒt@Cǂ݂Ƃ܂BǗ҂ɘAĂB\r\n");
		return 0;
		}

// ݂̃fBNgcgĩfBNgɈڂ
strncpy(argvcopy, argv[0], PATH_MAX);
argvcopy[PATH_MAX-1]=0;
if (chdir(dirname(argvcopy)) != 0)
	{
	printf("Content-Type: text/plain\r\n\r\n");
	printf("fBNgړł܂łBǗ҂ɘAĂB\r\n");
	return 0;
	}

// ϐ REMOTE_ADDR ͕K{
if (getenv("REMOTE_ADDR") == NULL)
	{
	printf("Content-Type: text/plain\r\n\r\n");
	printf("ϐ REMOTE_ADDR ݒ肳Ă܂BǗ҂ɘAĂB\r\n");
	return 0;
	}
RemoteAddr=getenv("REMOTE_ADDR");

// tH[ɋLς݂Ȃ΃fR[h
Length=0;
if (getenv("CONTENT_LENGTH") != NULL)
	{
	CString QueryString;
	int i;

	try	{
		Length=atoi(getenv("CONTENT_LENGTH"));
		for(i=0;i<Length;i++) QueryString+=(char)fgetc(stdin);
		Query.Open(QueryString);
		} catch (CException& e)
			{
			printf("Content-Type: text/plain\r\n\r\n");
			printf("tH[f[^ǂ݂Ƃ܂łBǗ҂ɘAĂB\r\n");
			return 0;
			}
	}

// KvȃtH[ACe݂Ă邱ƂmF
if ((Query.IsExistItem("MESSAGE") != 1)||
	(Query.IsExistItem("key") != 1))
	{
	// puEU΍Ƃĉ\ɏI
	printf("Content-Type: text/html\r\n\r\n");
	printf("<a href=\"../\"> GO! </a>\r\n");
	return 0;
	}

// ݎ擾
CurrentTime.SetDateAndTimeLocalCurrent();

// bZ[WłĂ͂ȂȂ
if (Query.GetItemValue("MESSAGE").Length < 1)
	{
	// G[
	BbsCgiErrorOut("bZ[WLĂ܂B", "", "", "");
	return 0;
	}

ErrorOutFlag=0;
try	{
	// bZ[WeLXg𐶐
	Src=Query.GetItemValue("MESSAGE").EncodeIllegalHtmlChar();
	MessageText.Empty();
	j=0;
	for(i=0;i<Src.Length;i++)
		{
		switch (Src[i])
			{
			case 13:
				// ^Oɕϊ
				MessageText+="<br>";
				break;
			case 10:
				// Ȃ
				break;
			default:
				MessageText+=Src[i];
			}
		}
	if (Config.IsExistItemName("BoardArticleMaxLength") == 1)
		{
		if (MessageText.Length > atoi(Config.GetItemValue("BoardArticleMaxLength")))
			{
			// bZ[W{
			BbsCgiErrorOut("{܂B", "", "", "");
			ErrorOutFlag=1;
			throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
			}
		}

	// O𐶐
	if (Query.IsExistItem("FROM") == 1)
		Src=Query.GetItemValue("FROM").EncodeIllegalHtmlChar();
	else	Src.Empty();
	From.Empty();
	for(i=0;i<Src.Length;i++)
		{
		if ((char unsigned)(Src[i]) >= 32) From+=Src[i];
		}
	if (From.Length < 1)
		{
		if (Config.IsExistItemName("BoardAnonymousName") == 1)
			From=Config.GetItemValue("BoardAnonymousName");
		else	From="񁗂ς";
		}

	// ""  "", ""  "" ւ̕ϊ
	From=From.Replace("", -1, "", -1).Replace("", -1, "", -1);

	// fusianasan΍
	if (From.Find("fusianasan") >= 0)
		{
		struct hostent *host;
		struct in_addr in;

		in.s_addr=inet_addr(RemoteAddr);
		host=gethostbyaddr((const char *)(&in), sizeof(struct in_addr), AF_INET);
		if (host == NULL)
			Src.Format("(IP)%s", (const char *)RemoteAddr);
		else	Src.Format("(FQDN)%s", (const char *)host->h_name);
		Src=Src.EncodeIllegalHtmlChar();
		Src="</b>" + Src;
		Src=Src + "<b>";

		From=From.Replace("fusianasan", -1, (char *)(const char *)Src, -1);
		}

	// gbv΍
	if (From.Find('#') >= 0)
		{
		CString TripSourceStr, TripSourceStr2;
		CMd5 Md5;

		// gbv𐶐
		TripSourceStr=From.Mid(From.Find('#')+1);
		TripSourceStr2="#" + TripSourceStr;
		Md5.Init();
		Md5.Update((char unsigned *)(const char *)TripSourceStr, TripSourceStr.Length);
		Md5.Finish();
		Src="</b>" + Md5.ToMimeString().Left(8);
		Src=Src + "<b>";

		From=From.Replace(TripSourceStr2, Src);
		}

	// [AhX𐶐
	if (Query.IsExistItem("mail") == 1)
		Src=Query.GetItemValue("mail").EncodeIllegalHtmlChar();
	else	Src.Empty();
	Mail.Empty();
	for(i=0;i<Src.Length;i++)
		{
		if ((char unsigned)(Src[i])  >= 32) Mail+=Src[i];
		}

	// ID^zXg𐶐
	if (Config.IsExistItemName("BoardShowHostMode") == 1)
		BoardShowHostMode=atoi(Config.GetItemValue("BoardShowHostMode"));
	else	BoardShowHostMode=0;
	if ((BoardShowHostMode == 0)||(BoardShowHostMode == 2))
		{
		CMd5 Md5;

		if ((BoardShowHostMode == 2)||(Mail.Length < 1))
			{
			// ID𐶐
			Md5.Init();
			Md5.Update((char unsigned *)RemoteAddr, strlen(RemoteAddr));
			Md5.Update((char unsigned *)(&CurrentTime.Year), sizeof(CurrentTime.Year));
			Md5.Update((char unsigned *)(&CurrentTime.Month), sizeof(CurrentTime.Month));
			Md5.Update((char unsigned *)(&CurrentTime.Day), sizeof(CurrentTime.Day));
			Md5.Finish();

			IdHostString.Format("ID:%8.8s", (const char *)Md5.ToMimeString());
			}
		else	IdHostString.Format("ID:???");
		}
	else if ((BoardShowHostMode == 1)||(BoardShowHostMode == 3))
		{
		struct hostent *host;
		struct in_addr in;

		if ((BoardShowHostMode == 3)||(Mail.Length < 1))
			{
			// zXg𐶐
			in.s_addr=inet_addr(RemoteAddr);
			host=gethostbyaddr((const char *)(&in), sizeof(struct in_addr), AF_INET);
			if (host == NULL)
				IdHostString.Format("Host:(IP)%s", (const char *)RemoteAddr);
			else	IdHostString.Format("Host:(FQDN)%s", (const char *)host->h_name);
			IdHostString=IdHostString.EncodeIllegalHtmlChar();
			}
		else	IdHostString.Format("Host:???");
		}

	// ۂɃbZ[W
	ThreadKey=atoi(Query.GetItemValue("key"));
	FileNamePath.Format("../board/dat/%i.dat", ThreadKey);
	if (stat((const char *)FileNamePath, &st) != 0)
		throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
	if (!S_ISREG(st.st_mode))
		{
		// G[
		BbsCgiErrorOut("w肵Xbh݂͑܂B", "", "", "");
		ErrorOutFlag=1;
		throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
		}

	// s𐔂邽߂ɓǂݍݐpŊJ
	hDatFile=fopen((const char *)FileNamePath, "rt");
	if (hDatFile == NULL)
		throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));

	// siݐj𓾂
	rewind(hDatFile);
	Lines=0;
	while (feof(hDatFile) == 0)
		{
		ReadFileLine(hDatFile, 0x8000);
		Lines++;
		}
	rewind(hDatFile);

	// ĊJ
	fclose(hDatFile);

	hDatFile=fopen((const char *)FileNamePath, "at");
	if (hDatFile == NULL)
		{
		BbsCgiErrorOut("̃XbhɏނƂ͂ł܂B", "", "", "");
		ErrorOutFlag=1;
		throw(CException(CException::CErrorTypeException, CException::CIllegalStatus, "BbsCgi"));
		}

	// A[Zbg
	alarm(30);

	// bN
	memset((void *)(&lock), 0, sizeof(struct flock));
	lock.l_type=F_WRLCK;
	lock.l_whence=SEEK_SET;
	lock.l_start=0;
	lock.l_len=0;
	if (fcntl(fileno(hDatFile), F_SETLKW, &lock) != 0)
		{
		// G[
		BbsCgiErrorOut("datt@C̃bNɎs܂B", "", "", "");
		ErrorOutFlag=1;
		throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
		}

	// A[Zbg
	alarm(0);

	// 
	fprintf(hDatFile, "%s<>%s<>%04i/%02i/%02i %02i:%02i:%02i %s<>%s<>\n",
		(const char *)From, (const char *)Mail,
		CurrentTime.Year, CurrentTime.Month, CurrentTime.Day,
		CurrentTime.Hour, CurrentTime.Minute, CurrentTime.Second,
		(const char *)IdHostString, (const char *)MessageText);

	// ݐő𒴂Ă΃Xbh͏I
	if (Config.IsExistItemName("BoardMaxArticle") == 1)
		{
		int BoardMaxArticle;
		
		BoardMaxArticle=atoi(Config.GetItemValue("BoardMaxArticle"));
		if (Lines >= BoardMaxArticle)
			{
			struct stat st;

			// overbZ[W
			fprintf(hDatFile, "%i<><>Over %i<>̃Xbh%i𒴂܂B<br>Ȃ̂ŁAVXbh𗧂ĂĂłBBB <>\n",
				BoardMaxArticle+1, BoardMaxArticle, BoardMaxArticle);

			// ݂̃p[~bV𓾂
			if (fstat(fileno(hDatFile), &st) != 0)
				{
				fclose(hDatFile);
				throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
				}

			// p[~bVύX
			if (fchmod(fileno(hDatFile), (st.st_mode)&(~(S_IWUSR|S_IWGRP|S_IWOTH))) != 0)
				{
				fclose(hDatFile);
				throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
				}
			}
		}

	// bN
	memset((void *)(&lock), 0, sizeof(struct flock));
	lock.l_type=F_UNLCK;
	lock.l_whence=SEEK_SET;
	lock.l_start=0;
	lock.l_len=0;
	if (fcntl(fileno(hDatFile), F_SETLKW, &lock) != 0)
		{
		// G[
		BbsCgiErrorOut("datt@C̃bNɎs܂B", "", "", "");
		ErrorOutFlag=1;
		throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
		}

	fclose(hDatFile);

	// ݏIbZ[W\
	printf("Content-Type: text/html; charset=\"shift_jis\"\r\n\r\n");
	PrintPageBeginning(stdout, Config, "Xbh`f - ݏI");

	printf("<p align=\"center\"> ݂I܂B <a href=\"read.cgi?bbs=board&key=%i&ls=50\"> ꗗɖ߂ </a> </p>\n", ThreadKey);
	} catch (CException& e)
		{
		// httpwb_
		if (ErrorOutFlag == 0)
			BbsCgiErrorOut("G[܂Bvꂽ̓LZ܂B", "", "", "");
		if (atoi((const char *)Config.GetItemValue("ShowDebugMessage")) > 0)
			printf("<p> %s @ %s </p>",
				(const char *)e.GetErrorMessage(), (const char *)e.GetErrorPosition());
		}

// y[W̏Io
PrintPageEnding(stdout, Config);

return 0;
}
