#include "../baseclasses/CString.h"
#include "../baseclasses/CConfig.h"
#include "../baseclasses/CQueryString.h"
#include "CUploadedFiles.h"
#include "adminmenucgi_def.h"
#include <fcntl.h>

void AdminThreadStop(CString UserName, CConfig& Config, CConfig& PrivConfig,
	CQueryString& Form, CQueryString& QueryString)
{
int ThreadKey;
CString ThreadFileName;
struct stat st;
struct flock lock;
FILE *hDatFile;
CString ThreadStopName, ThreadStopMessage;
CTime CurrentTime;

// KvȃtH[ACe݂Ă邩ǂm߂
if (QueryString.IsExistItem("key") != 1)
	{
	printf("<p> XbhL[w肳Ă܂B </p>\r\n");
	throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "ReadCgi"));
	}

if (QueryString.IsExistItem("StopName") == 1)
	ThreadStopName=QueryString.GetItemValue("StopName");
else	ThreadStopName="^EXbhXgbp[";

if (QueryString.IsExistItem("StopMessage") == 1)
	ThreadStopMessage=QueryString.GetItemValue("StopMessage");
else	ThreadStopMessage="܂(P[P)د";

// Xbht@C쐬
ThreadKey=atoi(QueryString.GetItemValue("key"));
ThreadFileName.Format("../../board/dat/%i.dat", ThreadKey);

hDatFile=fopen((const char *)ThreadFileName, "at");
if (hDatFile == NULL)
	{
	printf("<p> ̃XbhɏނƂ͂ł܂BɃXbhXgbvς݂Ap[~bV̐ݒ肪o܂B </p>");
	throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
	}

// A[Zbg
alarm(30);

// bN
memset((void *)(&lock), 0, sizeof(struct flock));
lock.l_type=F_WRLCK;
lock.l_whence=SEEK_SET;
lock.l_start=0;
lock.l_len=0;
if (fcntl(fileno(hDatFile), F_SETLKW, &lock) != 0)
	{
	// G[
	printf("<p> datt@C̃bNɎs܂B </p>");
	throw(CException(CException::CErrorTypeErrorCode, errno, "AdminThreadStop"));
	}

// A[Zbg
alarm(0);

// ݎ擾
CurrentTime.SetDateAndTimeLocalCurrent();

// XbhXgbvbZ[W
fprintf(hDatFile, "%s<><>~ <>%s <br><b>~: %04i/%02i/%02i %02i:%02i:%02i</b> <>\n",
	(const char *)ThreadStopName,
	(const char *)ThreadStopMessage,
	CurrentTime.Year, CurrentTime.Month, CurrentTime.Day,
	CurrentTime.Hour, CurrentTime.Minute, CurrentTime.Second);

// ݂̃p[~bV𓾂
if (fstat(fileno(hDatFile), &st) != 0)
	{
	fclose(hDatFile);
	throw(CException(CException::CErrorTypeErrorCode, errno, "AdminThreadStop"));
	}

// p[~bVύX
if (fchmod(fileno(hDatFile), (st.st_mode)&(~(S_IWUSR|S_IWGRP|S_IWOTH))) != 0)
	{
	fclose(hDatFile);
	throw(CException(CException::CErrorTypeErrorCode, errno, "AdminThreadStop"));
	}

// bN
memset((void *)(&lock), 0, sizeof(struct flock));
lock.l_type=F_UNLCK;
lock.l_whence=SEEK_SET;
lock.l_start=0;
lock.l_len=0;
if (fcntl(fileno(hDatFile), F_SETLKW, &lock) != 0)
	{
	// G[
	printf("<p> datt@C̃bNɎs܂B </p>");
	throw(CException(CException::CErrorTypeErrorCode, errno, "AdminThreadStop"));
	}

printf("<p align=\"center\"> w肵Xbh~܂B </p>\r\n");
printf("<p align=\"center\"> <a href=\"adminmenu.cgi?Command=FileThreadBrowse&key=%i?ls=50\"> Xbhɖ߂ </a> </p>\r\n", ThreadKey);

fclose(hDatFile);
}

void AdminThreadResume(CString UserName, CConfig& Config, CConfig& PrivConfig,
	CQueryString& Form, CQueryString& QueryString)
{
int ThreadKey;
CString ThreadFileName;
struct stat st;
struct flock lock;
FILE *hDatFile;
CString ThreadResumeName, ThreadResumeMessage;
CTime CurrentTime;

// KvȃtH[ACe݂Ă邩ǂm߂
if (QueryString.IsExistItem("key") != 1)
	{
	printf("<p> XbhL[w肳Ă܂B </p>\r\n");
	throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "ReadCgi"));
	}

if (QueryString.IsExistItem("ResumeName") == 1)
	ThreadResumeName=QueryString.GetItemValue("ResumeName");
else	ThreadResumeName="^EXbhX^[^[";

if (QueryString.IsExistItem("ResumeMessage") == 1)
	ThreadResumeMessage=QueryString.GetItemValue("ResumeMessage");
else	ThreadResumeMessage="܂(P[P)د";

// Xbht@C쐬
ThreadKey=atoi(QueryString.GetItemValue("key"));
ThreadFileName.Format("../../board/dat/%i.dat", ThreadKey);

// ݂̃p[~bV𓾂
if (stat((const char *)ThreadFileName, &st) != 0)
	{
	fclose(hDatFile);
	throw(CException(CException::CErrorTypeErrorCode, errno, "AdminThreadResume"));
	}

// p[~bVύX
if (chmod((const char *)ThreadFileName, (st.st_mode)|(S_IWUSR|S_IWGRP|S_IWOTH)) != 0)
	{
	fclose(hDatFile);
	throw(CException(CException::CErrorTypeErrorCode, errno, "AdminThreadResume"));
	}

hDatFile=fopen((const char *)ThreadFileName, "at");
if (hDatFile == NULL)
	{
	printf("<p> ̃XbhɏނƂ͂ł܂BɃXbhXgbvς݂Ap[~bV̐ݒ肪o܂B </p>");
	throw(CException(CException::CErrorTypeErrorCode, errno, "BbsCgi"));
	}

// A[Zbg
alarm(30);

// bN
memset((void *)(&lock), 0, sizeof(struct flock));
lock.l_type=F_WRLCK;
lock.l_whence=SEEK_SET;
lock.l_start=0;
lock.l_len=0;
if (fcntl(fileno(hDatFile), F_SETLKW, &lock) != 0)
	{
	// G[
	printf("<p> datt@C̃bNɎs܂B </p>");
	throw(CException(CException::CErrorTypeErrorCode, errno, "AdminThreadResume"));
	}

// A[Zbg
alarm(0);

// ݎ擾
CurrentTime.SetDateAndTimeLocalCurrent();

// XbhXgbvbZ[W
fprintf(hDatFile, "%s<><>ĊJ <>%s <br><b>ĊJ: %04i/%02i/%02i %02i:%02i:%02i</b> <>\n",
	(const char *)ThreadResumeName,
	(const char *)ThreadResumeMessage,
	CurrentTime.Year, CurrentTime.Month, CurrentTime.Day,
	CurrentTime.Hour, CurrentTime.Minute, CurrentTime.Second);

// bN
memset((void *)(&lock), 0, sizeof(struct flock));
lock.l_type=F_UNLCK;
lock.l_whence=SEEK_SET;
lock.l_start=0;
lock.l_len=0;
if (fcntl(fileno(hDatFile), F_SETLKW, &lock) != 0)
	{
	// G[
	printf("<p> datt@C̃bNɎs܂B </p>");
	throw(CException(CException::CErrorTypeErrorCode, errno, "AdminThreadResume"));
	}

printf("<p align=\"center\"> w肵XbhĊJ܂B </p>\r\n");
printf("<p align=\"center\"> <a href=\"adminmenu.cgi?Command=FileThreadBrowse&key=%i?ls=50\"> Xbhɖ߂ </a> </p>\r\n", ThreadKey);

fclose(hDatFile);
}
