#include "UploadFileCheck.h"
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>

#define max(a,b)	((a>b)?a:b)

#define	BUFFERSIZE	4096
int UploadFileCheck(CConfig& Config, CString TempFileName)
{
int ChildProcessPipeStdin[2];
int ChildProcessPipeStdout[2];
int ChildProcessPipeStderr[2];
pid_t pid;
fd_set readfd, writefd, exceptionfd;
char Buffer[BUFFERSIZE];
int i, j, k, Size, status;
struct timeval tm;
CString Str, UploadCheckFile, UploadCheckSuccessfulReturnCode;
int UploadCheckTimeout;

if ((Config.IsExistItemName("UploadCheck") == 0)||
	(atoi(Config.GetItemValue("UploadCheck")) < 1))
	return 0;	// Ȃł̂܂܋A

// R}hCƃp[^擾
if ((Config.IsExistItemName("UploadCheckFile") == 0)
	||(Config.IsExistItemName("UploadCheckTimeout") == 0))
	{
	throw(CException(CException::CErrorTypeException,
		CException::CIllegalParameter, "UploadFileCheck"));
	}
UploadCheckFile=Config.GetItemValue("UploadCheckFile");
UploadCheckTimeout=atoi(Config.GetItemValue("UploadCheckTimeout"));

// qvZXƂ̒ʐMp̃pCv쐬
if (pipe(ChildProcessPipeStdin) < 0)
	throw(CException(CException::CErrorTypeErrorCode, errno, "UploadFileCheck"));
if (pipe(ChildProcessPipeStdout) < 0)
	{
	close(ChildProcessPipeStdin[0]);
	close(ChildProcessPipeStdin[1]);
	throw(CException(CException::CErrorTypeErrorCode, errno, "UploadFileCheck"));
	}
if (pipe(ChildProcessPipeStderr) < 0)
	{
	close(ChildProcessPipeStdin[0]);
	close(ChildProcessPipeStdin[1]);
	close(ChildProcessPipeStdout[0]);
	close(ChildProcessPipeStdout[1]);
	throw(CException(CException::CErrorTypeErrorCode, errno, "UploadFileCheck"));
	}

// fork
if ((pid=fork()) < 0)
	{
	close(ChildProcessPipeStdin[0]);
	close(ChildProcessPipeStdin[1]);
	close(ChildProcessPipeStdout[0]);
	close(ChildProcessPipeStdout[1]);
	close(ChildProcessPipeStderr[0]);
	close(ChildProcessPipeStderr[1]);
	throw(CException(CException::CErrorTypeErrorCode, errno, "UploadFileCheck"));
	}

if (pid == 0)
	{
	CArray<CString, CString> UploadCheckFile_Args;
	char **argv;

	// qvZX̏
	close(ChildProcessPipeStdin[1]);
	close(ChildProcessPipeStdout[0]);
	close(ChildProcessPipeStderr[0]);
	close(fileno(stdin));
	close(fileno(stdout));
	close(fileno(stderr));
	dup2(ChildProcessPipeStdin[0], fileno(stdin));
	dup2(ChildProcessPipeStdout[1], fileno(stdout));
	dup2(ChildProcessPipeStderr[1], fileno(stderr));
	close(ChildProcessPipeStdin[0]);
	close(ChildProcessPipeStdout[1]);
	close(ChildProcessPipeStderr[1]);

	i=0;
	while (-1)
		{
		Str.Format("UploadCheckFile_Arg%i", i);
		if (Config.IsExistItemName(Str) == 0) break;
		UploadCheckFile_Args.Add(Config.GetItemValue(Str));

		i++;
		}
	argv=(char **)malloc(sizeof(char *)*(UploadCheckFile_Args.Size+2));
	if (argv == NULL) exit(1);
	for(i=0;i<UploadCheckFile_Args.Size;i++)
		argv[i]=(char *)(const char *)UploadCheckFile_Args[i];
	argv[UploadCheckFile_Args.Size]=(char *)(const char *)TempFileName;
	argv[UploadCheckFile_Args.Size+1]=NULL;

	if (execvp((const char *)UploadCheckFile, argv) < 0) exit(1);
	exit(0);
	}

// evZX̏

// svȃnh
close(ChildProcessPipeStdin[1]);

close(ChildProcessPipeStdin[0]);
close(ChildProcessPipeStdout[1]);
close(ChildProcessPipeStderr[1]);

// o͂̎o
if (atoi((const char *)Config.GetItemValue("ShowDebugMessage")) > 0)
	{
	printf("<pre>\r\n");
	while (-1)
		{
		FD_ZERO(&readfd);
		FD_ZERO(&writefd);
		FD_ZERO(&exceptionfd);
		FD_SET(ChildProcessPipeStdout[0], &readfd);
		FD_SET(ChildProcessPipeStderr[0], &readfd);
		FD_SET(ChildProcessPipeStdout[0], &exceptionfd);
		FD_SET(ChildProcessPipeStderr[0], &exceptionfd);
		tm.tv_sec=UploadCheckTimeout;
		tm.tv_usec=0;
		if (select(max(ChildProcessPipeStdout[0], ChildProcessPipeStderr[0])+1,
			&readfd, &writefd, &exceptionfd, &tm) == 0) break;

		if (FD_ISSET(ChildProcessPipeStdout[0], &readfd) > 0)
			{
			Size=read(ChildProcessPipeStdout[0], Buffer, BUFFERSIZE);
			if (Size < 1) break;
			Buffer[min(Size, BUFFERSIZE-1)]=0;
			printf("%s", Buffer);
			}
		if (FD_ISSET(ChildProcessPipeStderr[0], &readfd) > 0)
			{
			Size=read(ChildProcessPipeStderr[0], Buffer, BUFFERSIZE);
			Buffer[min(Size, BUFFERSIZE-1)]=0;
			printf("%s", Buffer);
			}
		if ((FD_ISSET(ChildProcessPipeStdout[0], &exceptionfd) > 0)
			||(FD_ISSET(ChildProcessPipeStderr[0], &exceptionfd) > 0))
			break;
		}
	printf("</pre>\r\n");
	}
close(ChildProcessPipeStdout[0]);
close(ChildProcessPipeStderr[0]);
if (waitpid(pid, &status, 0) == -1)
	throw(CException(CException::CErrorTypeErrorCode, errno, "UploadFileCheck"));

// IXe[^X`FbN
if (Config.IsExistItemName("UploadCheckSuccessfulReturnCode") == 1)
	UploadCheckSuccessfulReturnCode=Config.GetItemValue("UploadCheckSuccessfulReturnCode");
else	UploadCheckSuccessfulReturnCode="";

i=0;
k=0;
while (-1)
	{
	j=UploadCheckSuccessfulReturnCode.Find(',', i, 1, 1);
	if (j < 0)
		{
		if (atoi(UploadCheckSuccessfulReturnCode.Mid(i)) == WEXITSTATUS(status))
			k=1;
		break;
		}
	else	{
		if (atoi(UploadCheckSuccessfulReturnCode.Mid(i, j-i)) == WEXITSTATUS(status))
			{
			k=1;
			break;
			}
		}
	i=j+1;
	}

if (k == 0)
	return 1;
else	return 0;
}
