#include "RemakeIndex.h"
#include "printpage.h"

void PrintPageIndex(FILE *hFile, int CurrentPage, int MaxPage)
{
int i;

// y[WCfbNXo
fprintf(hFile, "<p align=\"center\"> Page ");
if (CurrentPage > 0)
	fprintf(hFile, "<a href=\"page%i.html\"> Prev&lt;&lt; </a> ", CurrentPage);
else	fprintf(hFile, "Prev&lt;&lt;");
for(i=0;i<=MaxPage;i++)
	{
	if (CurrentPage != i)
		fprintf(hFile, "<a href=\"page%i.html\"> %i </a> &nbsp; ", i+1, i+1);
	else	fprintf(hFile, "<b> <u>%i</u> </b> &nbsp; ", i+1);
	}
if (CurrentPage < MaxPage)
	fprintf(hFile, "<a href=\"page%i.html\"> &gt;&gt;Next </a>", CurrentPage+2);
else	fprintf(hFile, "&gt;&gt;Next");
fprintf(hFile, "</p>\r\n");
}

// CfbNXč쐬
void RemakeIndex(CConfig& Config, CString TargetDir)
{
CUploadedFiles Files;
int MaxFiles, FilesPerPage, MaxPage;
int i, j, k, l;
CString FileNamePath, PageString;
CString Str;
FILE *hFile;
int UseSSLInAdminMenu, ShowAdminMenu;
char unsigned ch;

if (Config.IsExistItemName("UploadMaxFiles") == 1)
	MaxFiles=atoi(Config.GetItemValue("UploadMaxFiles"));
else	return;	// w肪Ȃ̂ŉȂ
if (MaxFiles < 1) return;	// w肪Ȃ̂ŉȂ

if (Config.IsExistItemName("UploadFilesPerPage") == 1)
	FilesPerPage=atoi(Config.GetItemValue("UploadFilesPerPage"));
else	return;	// w肪Ȃ̂ŉȂ
if (FilesPerPage < 1) return;	// w肪Ȃ̂ŉȂ

if (Config.IsExistItemName("ShowAdminMenu") == 1)
	ShowAdminMenu=atoi(Config.GetItemValue("ShowAdminMenu"));
else	ShowAdminMenu=0;

if (Config.IsExistItemName("UseSSLInAdminMenu") == 1)
	UseSSLInAdminMenu=atoi(Config.GetItemValue("UseSSLInAdminMenu"));
else	UseSSLInAdminMenu=0;

// Abv[hς݂̃t@Cꗗ擾
Files.Open(TargetDir);

// y[W쐬
MaxPage=(MaxFiles/FilesPerPage)+(((MaxFiles%FilesPerPage) > 0)?1:0)-1;
for(i=0;i<=MaxPage;i++)
	{
	FileNamePath.Format("../page%i.html", i+1);
	if ((unlink((const char *)FileNamePath) == -1)&&(errno != ENOENT))
		throw(CException(CException::CErrorTypeErrorCode,
			errno, "RemakeIndex"));

	hFile=fopen((const char *)FileNamePath, "wt");
	if (hFile == NULL)
		throw(CException(CException::CErrorTypeErrorCode,
			errno, "RemakeIndex"));

	// y[W̖`o
	PageString.Format("y[W %i/%i", i+1, MaxPage+1);
	PrintPageBeginning(hFile, Config, PageString);

	// y[WCfbNXo
	PrintPageIndex(hFile, i, MaxPage);

	fprintf(hFile, "<p align=\"right\"> <a href=\"cgi-bin/uploadform.cgi\">  Abv[h </a>");
	if ((ShowAdminMenu == 1)&&(UseSSLInAdminMenu == 1))
		{
		CString ServerName, URI;

		if (getenv("SERVER_NAME") != NULL)
			ServerName=getenv("SERVER_NAME");
		else	ServerName="localhost";

		if (getenv("REQUEST_URI") != NULL)
			{
			URI=getenv("REQUEST_URI");
			if (URI.Find('/', URI.Length-1, 1, -1) > 0)
				URI=URI.Left(URI.Find('/', URI.Length-1, 1, -1));
			}
		else	URI.Empty();

		fprintf(hFile, "<a href=\"https://%s%s/admin/adminmenu.cgi\">  Ǘʂ </a> </p>\r\n",
			(const char *)ServerName, (const char *)URI);
		}
	else if (ShowAdminMenu == 1)
		fprintf(hFile, "<a href=\"cgi-bin/admin/adminmenu.cgi\">  Ǘʂ </a> </p>\r\n");

	fprintf(hFile, "<table border=\"0\" width=\"100%%\">\r\n");
	fprintf(hFile, "\t<tr>\r\n");
	fprintf(hFile, "\t\t<th>\r\n");
	fprintf(hFile, "\t\t\t<font size=\"-1\"> t@C </font>\r\n");
	fprintf(hFile, "\t\t</th>\r\n");
	fprintf(hFile, "\t\t<th>\r\n");
	fprintf(hFile, "\t\t\t<font size=\"-1\"> Rg </font>\r\n");
	fprintf(hFile, "\t\t</th>\r\n");
	fprintf(hFile, "\t\t<th>\r\n");
	fprintf(hFile, "\t\t\t<font size=\"-1\"> TCY </font>\r\n");
	fprintf(hFile, "\t\t</th>\r\n");
	fprintf(hFile, "\t\t<th>\r\n");
	fprintf(hFile, "\t\t\t<font size=\"-1\"> t </font>\r\n");
	fprintf(hFile, "\t\t</th>\r\n");
	fprintf(hFile, "\t\t<th colspan=\"2\">\r\n");
	fprintf(hFile, "\t\t\t<font size=\"-1\">  </font>\r\n");
	fprintf(hFile, "\t\t</th>\r\n");
	fprintf(hFile, "\t</tr>\r\n");
	for(j=0;j<FilesPerPage;j++)
		{
		if (Files.Items.Size <= i*FilesPerPage+j) break;

		fprintf(hFile, "\t<tr>\r\n");

		fprintf(hFile, "\t\t<td align=\"center\"> <font size=\"-1\">\r\n");
		fprintf(hFile, "\t\t\t<a href=\"source/%s\"> %s </a>\r\n",
			(const char *)Files.Items[i*FilesPerPage+j].FileName,
			(const char *)Files.Items[i*FilesPerPage+j].FileName);
		fprintf(hFile, "\t\t</font> </td>\r\n");

		fprintf(hFile, "\t\t<td align=\"center\"> <font size=\"-1\">\r\n");
		Str=Files.Items[i*FilesPerPage+j].GetCommentText().Left(40);
		l=0;
		for(k=0;k<Str.Length;k++)
			{
			if (l == 1) l=0;
			else	{
				ch=(char unsigned)Str[k];
				if ((ch >= 0x81 && ch <= 0x9f) || (ch >= 0xe0 && ch <= 0xf5)) l=1;
				}
			}
		if (l == 1) Str=Str.Left(Str.Length-1);
		fprintf(hFile, "\t\t\t %s \r\n",
			(const char *)Str);
		fprintf(hFile, "\t\t</font> </td>\r\n");

		fprintf(hFile, "\t\t<td align=\"center\"> <font size=\"-1\">\r\n");
		if (Files.Items[i*FilesPerPage+j].FileSize < (1 << 10))
			Str.Format("%i", Files.Items[i*FilesPerPage+j].FileSize);
		else if (Files.Items[i*FilesPerPage+j].FileSize < (1 << 20))
			Str.Format("%i k", (Files.Items[i*FilesPerPage+j].FileSize >> 10));
		else if (Files.Items[i*FilesPerPage+j].FileSize < (1 << 30))
			Str.Format("%i M", (Files.Items[i*FilesPerPage+j].FileSize >> 20));
		else	Str.Format("%i G", (Files.Items[i*FilesPerPage+j].FileSize >> 30));
		fprintf(hFile, "\t\t\t%s\r\n", (const char *)Str);
		fprintf(hFile, "\t\t</font> </td>\r\n");

		fprintf(hFile, "\t\t<td align=\"center\"> <font size=\"-1\">\r\n");
		fprintf(hFile, "\t\t\t %s \r\n",
			(const char *)Files.Items[i*FilesPerPage+j].LastModificationTime.ToCString("%Y/%m/%d(%a) %H:%M:%S"));
		fprintf(hFile, "\t\t</font> </td>\r\n");

		Str=Files.Items[i*FilesPerPage+j].FileName;
		if (Str.Find('.', Str.Length-1, 1, -1) >= 0) Str=Str.Left(Str.Find('.', Str.Length-1, 1, -1));
		fprintf(hFile, "\t\t<td align=\"center\"> <font size=\"-1\">\r\n");
		fprintf(hFile, "\t\t\t<a href=\"test/read.cgi?bbs=board&key=%s\"> XQ </a>\r\n", (const char *)Str);
		fprintf(hFile, "\t\t</font> </td>\r\n");

		fprintf(hFile, "\t\t<form method=\"get\" action=\"cgi-bin/deleteform.cgi\">\r\n");
		fprintf(hFile, "\t\t\t<td align=\"center\"> <font size=\"-1\">\r\n");
		fprintf(hFile, "\t\t\t\t<input type=\"hidden\" name=\"FileName\" value=\"%s\">\r\n",
 			(const char *)Files.Items[i*FilesPerPage+j].FileName);
		fprintf(hFile, "\t\t\t\t<input type=\"submit\" value=\"폜\">\r\n");
		fprintf(hFile, "\t\t\t</font> </td>\r\n");
		fprintf(hFile, "\t\t</form>\r\n");

		fprintf(hFile, "\t</tr>\r\n");
		}
	fprintf(hFile, "</table>\r\n");

	// y[WCfbNXo
	PrintPageIndex(hFile, i, MaxPage);

	// y[W̏Io
	PrintPageEnding(hFile, Config);

	fclose(hFile);
	}

// Q˂uEUpCfbNX (subject.txt) 쐬
FileNamePath.Format("../board/subject.txt");
if ((unlink((const char *)FileNamePath) == -1)&&(errno != ENOENT))
	throw(CException(CException::CErrorTypeErrorCode,
		errno, "RemakeIndex"));

hFile=fopen((const char *)FileNamePath, "wt");
if (hFile == NULL)
	throw(CException(CException::CErrorTypeErrorCode,
		errno, "RemakeIndex"));

for(i=0;i<Files.Items.Size;i++)
	{
	// t@Cdatt@C쐬
	Str=Files.Items[i].FileName;
	if (Str.Find('.') >= 0)
		Str=Str.Left(Str.Find('.'));

	fprintf(hFile, "%s.dat<>%s (%i)\n",
		(const char *)Str,
		(const char *)Files.Items[i].GetCommentText(),
		0);
	}
fclose(hFile);

// V{bNN쐬
FileNamePath.Format("page1.html");
if (symlink((const char *)FileNamePath, "../index.html") == -1)
	{
	if (errno == EEXIST)
		{
		unlink("../index.html");
		if (symlink((const char *)FileNamePath, "../index.html") == -1)
			throw(CException(CException::CErrorTypeErrorCode,
				errno, "RemakeIndex"));
		}
	else	throw(CException(CException::CErrorTypeErrorCode,
			errno, "RemakeIndex"));
	}
}
