#include "GetInterval.h"
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/socket.h>

typedef struct
{
char unsigned AddressType;		/* future use; set AF_INET */
char unsigned Address[16];		/* address; if AddressType=AF_INET, Address is "unsigned long" */
struct timeval LastAccessed;		/* Last Access Time */
} IntervalLogItem;

#define	INTERVAL_MAXTIME	0x7fffffff
#define	DOWNLOADLOGFILENAME	"../DownloadLog.cgi"
#define	UPLOADLOGFILENAME	"../UploadLog.cgi"
#define	BOARDWRITELOGFILENAME	"../BoardWriteLog.cgi"

long int unsigned GetIntervalIpV4(int IntervalType, int LogInterval, unsigned long Address, long int unsigned Timeout)
{
struct timeval CurrentTime;
struct timezone tz;
FILE *hLogFile, *hTmpFile;
long int unsigned IntervalTime;
IntervalLogItem LogItem;
struct flock lock;

// ݎL
gettimeofday(&CurrentTime, &tz);

// Oǂݏo
switch (IntervalType)
	{
	case 0:
		hLogFile=fopen(DOWNLOADLOGFILENAME, "rb");
		break;
	case 1:
		hLogFile=fopen(UPLOADLOGFILENAME, "rb");
		break;
	case 2:
		hLogFile=fopen(BOARDWRITELOGFILENAME, "rb");
		break;
	default:
		throw(CException(CException::CErrorTypeException,
			CException::CIllegalParameter, "GetInterval"));
	}

// OɋLڂĂȂꍇ͍őlԂ悤ɂ
IntervalTime=INTERVAL_MAXTIME;

if (hLogFile != NULL)
	{
	// ŜLbNi݋֎~j
	lock.l_type=F_RDLCK;
	lock.l_whence=SEEK_SET;
	lock.l_start=(off_t)0;
	lock.l_len=(off_t)0;
	if (fcntl(fileno(hLogFile), F_SETLKW, &lock)  < 0)
		{
		int lasterrno;

		lasterrno=errno;
		fclose(hLogFile);
		throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
		}

	// Ƃ肠ǂݏoĊԊu`FbN
	rewind(hLogFile);
	while (fread((void *)(&LogItem), sizeof(LogItem), 1, hLogFile) > 0)
		{
		if ((LogItem.AddressType == AF_INET)&&
			(memcmp((void *)(LogItem.Address), (void *)(&Address), sizeof(unsigned long)) == 0))
			{
			IntervalTime=CurrentTime.tv_sec-LogItem.LastAccessed.tv_sec;
			break;
			}
		}

	// ŜbN
	lock.l_type=F_UNLCK;
	lock.l_whence=SEEK_SET;
	lock.l_start=(off_t)0;
	lock.l_len=(off_t)0;
	if (fcntl(fileno(hLogFile), F_SETLKW, &lock)  < 0)
		{
		int lasterrno;

		lasterrno=errno;
		fclose(hLogFile);
		throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
		}

	fclose(hLogFile);
	}

if (LogInterval == 0) return IntervalTime;

// Ot@CǂݏpɊJ
switch (IntervalType)
	{
	case 0:
		hLogFile=fopen(DOWNLOADLOGFILENAME, "r+b");
		if ((hLogFile == NULL)&&(errno == ENOENT))
			hLogFile=fopen(DOWNLOADLOGFILENAME, "w+b");
		break;
	case 1:
		hLogFile=fopen(UPLOADLOGFILENAME, "r+b");
		if ((hLogFile == NULL)&&(errno == ENOENT))
			hLogFile=fopen(UPLOADLOGFILENAME, "w+b");
		break;
	case 2:
		hLogFile=fopen(BOARDWRITELOGFILENAME, "r+b");
		if ((hLogFile == NULL)&&(errno == ENOENT))
			hLogFile=fopen(BOARDWRITELOGFILENAME, "w+b");
		break;
	default:
		throw(CException(CException::CErrorTypeException,
			CException::CIllegalParameter, "GetInterval"));
	}
if (hLogFile == NULL)
	throw(CException(CException::CErrorTypeErrorCode, errno, "GetInterval"));

// ŜrbNiǂݏ֎~j
lock.l_type=F_WRLCK;
lock.l_whence=SEEK_SET;
lock.l_start=(off_t)0;
lock.l_len=(off_t)0;
if (fcntl(fileno(hLogFile), F_SETLKW, &lock)  < 0)
	{
	int lasterrno;

	lasterrno=errno;
	fclose(hLogFile);
	throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
	}

// ꎞt@C쐬
hTmpFile=tmpfile();
if (hTmpFile == NULL)
	{
	int lasterrno;

	lasterrno=errno;
	fclose(hLogFile);
	throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
	}

// ꎞt@CɃRs[Ă
rewind(hLogFile);
while (fread((void *)(&LogItem), sizeof(LogItem), 1, hLogFile) > 0)
	{
	// Timeout߂ĂȂ̂
	if ((CurrentTime.tv_sec-LogItem.LastAccessed.tv_sec) < Timeout)
		{
		// 񎩕gOiォ珑̂Łj
		if ((LogItem.AddressType != AF_INET)||
			(memcmp((void *)(LogItem.Address), (void *)(&Address), sizeof(unsigned long)) != 0))
			{
			if (fwrite((void *)(&LogItem), sizeof(LogItem), 1, hTmpFile) < 1)
				{
				int lasterrno;

				lasterrno=errno;
				fclose(hTmpFile);
				fclose(hLogFile);
				throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
				}
			}
		}
	}

// g̋L^
LogItem.AddressType=AF_INET;
memset((void *)(LogItem.Address), 0, sizeof(LogItem.Address));
memcpy((void *)(LogItem.Address), (void *)(&Address), sizeof(unsigned long));
memcpy((void *)(&(LogItem.LastAccessed)), (void *)(&CurrentTime), sizeof(struct timeval));
if (fwrite((void *)(&LogItem), sizeof(LogItem), 1, hTmpFile) < 1)
	{
	int lasterrno;

	lasterrno=errno;
	fclose(hTmpFile);
	fclose(hLogFile);
	throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
	}

// Ot@C{̂ɃRs[
{
#define	BUFFERSIZE	8192
char unsigned Buffer[BUFFERSIZE];
int readsize;

rewind(hTmpFile);
rewind(hLogFile);
while ((readsize=fread((void *)Buffer, 1, BUFFERSIZE, hTmpFile)) > 0)
	{
	if (fwrite((void *)Buffer, readsize, 1, hLogFile) < 1)
		{
		int lasterrno;

		lasterrno=errno;
		fclose(hTmpFile);
		fclose(hLogFile);
		throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
		}
	}
}

// obt@͂o
fsync(fileno(hTmpFile));
fsync(fileno(hLogFile));

// t@C؂߂
if (ftruncate(fileno(hLogFile), (off_t)ftell(hLogFile)) != 0)
	{
	int lasterrno;

	lasterrno=errno;
	fclose(hTmpFile);
	fclose(hLogFile);
	throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
	}

// ŜbN
lock.l_type=F_UNLCK;
lock.l_whence=SEEK_SET;
lock.l_start=(off_t)0;
lock.l_len=(off_t)0;
if (fcntl(fileno(hLogFile), F_SETLKW, &lock)  < 0)
	{
	int lasterrno;

	lasterrno=errno;
	fclose(hLogFile);
	throw(CException(CException::CErrorTypeErrorCode, lasterrno, "GetInterval"));
	}

fclose(hTmpFile);
fclose(hLogFile);

return IntervalTime;
}
