#include "ExpireFiles.h"
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>

void DeleteExpiredFiles(CString TargetDir, CString FileName)
{
CString FileNamePath;

// t@C폜
FileNamePath.Format("%s/%s", (const char *)TargetDir, (const char *)FileName);
unlink((const char *)FileNamePath);
FileNamePath.Format("%s/%s.md5", (const char *)TargetDir, (const char *)FileName);
unlink((const char *)FileNamePath);
FileNamePath.Format("%s/%s.txt", (const char *)TargetDir, (const char *)FileName);
unlink((const char *)FileNamePath);
FileNamePath.Format("%s/%s.cgi", (const char *)TargetDir, (const char *)FileName);
unlink((const char *)FileNamePath);
}

// Ât@C폜
int ExpireFiles(CConfig& Config, CString TargetDir)
{
int MaxFiles;
CUploadedFiles Files;
int i, j, k;
int DeletedFiles;
CConfig FileSecretConfig;
CTime CurrentTime, AutoDeleteTime;
CString UploadDir;
struct dirent **ent;
int FileCount;

if (Config.IsExistItemName("UploadMaxFiles") == 1)
	MaxFiles=atoi(Config.GetItemValue("UploadMaxFiles"));
else	return 0;	// w肪Ȃ̂ŉȂ

if (MaxFiles < 1) return 0;	// w肪Ȃ̂ŉȂ

// ݎL
CurrentTime.SetDateAndTimeLocalCurrent();

// Abv[hς݂̃t@Cꗗ擾
Files.Open(TargetDir);
DeletedFiles=0;

// K萔ȏ͍폜
if (Files.Items.Size > MaxFiles)
	{
	for(i=MaxFiles;i<Files.Items.Size;i++)
		{
		DeleteExpiredFiles(TargetDir, Files.Items[i].FileName);
		DeletedFiles++;
		}
	}

// K萔łԐ؂͍̂̂폜
for(i=0;i<min(MaxFiles, Files.Items.Size);i++)
	{
	try	{
		FileSecretConfig=Files.Items[i].GetSecretItems();
		if (FileSecretConfig.IsExistItemName("AUTODELETETIME") == 1)
			{
			AutoDeleteTime.SetDateAndTime(FileSecretConfig.GetItemValue("AUTODELETETIME"));
			if (AutoDeleteTime < CurrentTime)
				{
				DeleteExpiredFiles(TargetDir, Files.Items[i].FileName);
				DeletedFiles++;
				}
			}
		} catch (CException& e)
			{
			// .cgit@C݂Ȃꍇ͖
			}
	}

// ēxAbv[hς݂̃t@Cꗗ擾
Files.Items.RemoveAll();
Files.Open(TargetDir);

// datt@C̐iłɑ݂Ȃ͍̂폜j
ent=NULL;
if ((FileCount=scandir("../board/dat", &ent, 0, alphasort)) > 0)
	{
	CString FileName, FileSeedName, Extension, FileNamePath;
	CString FileSeedName2;
	struct stat st;

	for(i=0;i<FileCount;i++)
		{
		FileName=ent[i]->d_name;
		if (FileName.Find('.', FileName.Length-1, 1, -1) >= 0)
			{
			FileSeedName=FileName.Left(FileName.Find('.', FileName.Length-1, 1, -1));
			Extension=FileName.Mid(FileName.Find('.', FileName.Length-1, 1, -1)+1);
			}
		else	{
			FileSeedName=FileName;
			Extension.Empty();
			}

		if (Extension == (char *)"dat")
			{
			FileNamePath.Format("../board/dat/%s", (const char *)FileName);
			if (stat((const char *)FileNamePath, &st) == -1) continue; // G[͖

			if (!S_ISREG(st.st_mode)) continue;	// t@CȊÔ̂ȂΖ
			
			// datt@CɑΉt@C݂邩H
			k=0;
			for(j=0;j<min(MaxFiles, Files.Items.Size);j++)
				{
				if (Files.Items[j].FileName.Find('.', Files.Items[j].FileName.Length-1, 1, -1) >= 0)
					FileSeedName2=Files.Items[j].FileName.Left(Files.Items[j].FileName.Find('.', Files.Items[j].FileName.Length-1, 1, -1));
				else	FileSeedName2=Files.Items[j].FileName;
				
				if (FileSeedName == FileSeedName2)
					{
					k=1;
					break;
					}
				}
				
			// Ήt@CȂ̂ō폜
			if (k == 0) unlink((const char *)FileNamePath);
			}
		}
	free(ent);
	}
if ((FileCount == 0)&&(ent != NULL)) free(ent);

return DeletedFiles;
}
