#include "CheckLoadAverage.h"
#include <stdlib.h>

#define	LOADAVERAGEITEMS	3

#ifndef GETLOADAVG
int getloadaverage(double *destLoadAvg, int destLoadAvgNum)
{
FILE *fil;
char str[256], *p, *p2, str2[256];
int i;

fil=fopen("/proc/loadavg", "rt");
if (fil == NULL) return -1;

fgets(str, 255, fil);
str[255]=0;

p=str;
i=0;
while (*p != 0)
	{
	p2=p;
	while ((*p2 != ' ')&&(*p2 != '\t')&&(*p2 != 0)) p2++;
	strncpy(str2, p, min((int)(p2-p), 255));
	str2[255]=0;
	destLoadAvg[i]=atof(str2);
	i++; if (i >= destLoadAvgNum) break;
	}

fclose(fil);
return i;
}
#endif

int CheckLoadAverage(int Purpose, CConfig& Config)
{
double load[LOADAVERAGEITEMS];
int ItemNum;
double MaxLoad;

#ifdef GETLOADAVG
if (getloadavg(load, LOADAVERAGEITEMS) != LOADAVERAGEITEMS)
	throw(CException(CException::CErrorTypeErrorCode, errno, "CheckLoadAverage"));
#else
if (getloadaverage(load, LOADAVERAGEITEMS) != LOADAVERAGEITEMS)
	throw(CException(CException::CErrorTypeErrorCode, errno, "CheckLoadAverage"));
#endif

switch (Purpose)
	{
	case 0:
		ItemNum=atoi(Config.GetItemValue("LoadaverageItemForDownload"));
		MaxLoad=atof(Config.GetItemValue("MaxLoadaverageForDownload"));
		break;
	case 1:
		ItemNum=atoi(Config.GetItemValue("LoadaverageItemForUpload"));
		MaxLoad=atof(Config.GetItemValue("MaxLoadaverageForUpload"));
		break;
	default:
		throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "CheckLoadAverage"));
	}

if ((ItemNum < 0)||(ItemNum >= LOADAVERAGEITEMS))
	throw(CException(CException::CErrorTypeException,
		CException::CIllegalParameter, "CheckLoadAverage"));
if (load[ItemNum] > MaxLoad)
	return 0;
else	return 1;
}
