#ifndef	CUploadedFiles_defined
#define	CUploadedFiles_defined

#include "../baseclasses/CString.h"
#include "../baseclasses/CArray.h"
#include "../baseclasses/CTime.h"
#include "../baseclasses/CConfig.h"
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

class CUploadedFiles_Item
{
public:
	CUploadedFiles_Item();
	CUploadedFiles_Item(CUploadedFiles_Item& srcItem);
	~CUploadedFiles_Item();

	CUploadedFiles_Item& operator=(CUploadedFiles_Item& srcItem);

	CString GetCommentText();
	CString GetMd5String();
	CConfig GetSecretItems();

	static CString ReadFileLine(FILE *hFile, int MaxLength);

	long iInodeNumber;
	// off_t iOffset;
	CString Path, FileName;
	long int unsigned FileSize;
	mode_t Permission;
	CTime LastAccessTime, LastModificationTime, LastChangeTime;
};

class CUploadedFiles
{
public:
	CUploadedFiles();
	~CUploadedFiles();

	static int LastModifiedCompare_NewFileFirst(CUploadedFiles_Item *Item1, CUploadedFiles_Item *Item2);
	void Open(CString TargetDirectory);

	CArray<CUploadedFiles_Item, CUploadedFiles_Item> Items;
};

#endif
