#include "CUploadedFiles.h"

CUploadedFiles_Item::CUploadedFiles_Item()
{
iInodeNumber=0;
// iOffset=0;
Path.Empty();
FileName.Empty();
FileSize=0;
Permission=0;
}

CUploadedFiles_Item::CUploadedFiles_Item(CUploadedFiles_Item& srcItem)
{
iInodeNumber=srcItem.iInodeNumber;
// iOffset=srcItem.iOffset;
Path=srcItem.Path;
FileName=srcItem.FileName;
FileSize=srcItem.FileSize;
Permission=srcItem.Permission;
LastAccessTime=srcItem.LastAccessTime;
LastModificationTime=srcItem.LastModificationTime;
LastChangeTime=srcItem.LastChangeTime;
}

CUploadedFiles_Item::~CUploadedFiles_Item()
{
iInodeNumber=0;
// iOffset=0;
Path.Empty();
FileName.Empty();
FileSize=0;
Permission=0;
}

CUploadedFiles_Item& CUploadedFiles_Item::operator=(CUploadedFiles_Item& srcItem)
{
iInodeNumber=srcItem.iInodeNumber;
// iOffset=srcItem.iOffset;
Path=srcItem.Path;
FileName=srcItem.FileName;
FileSize=srcItem.FileSize;
Permission=srcItem.Permission;
LastAccessTime=srcItem.LastAccessTime;
LastModificationTime=srcItem.LastModificationTime;
LastChangeTime=srcItem.LastChangeTime;

return (*this);
}

CString CUploadedFiles_Item::GetCommentText()
{
FILE *hFile;
CString TextFileName, CommentText;

TextFileName.Format("%s/%s.txt", (const char *)Path, (const char *)FileName);
hFile=fopen((const char *)TextFileName, "rt");
if (hFile != NULL)
	{
	CommentText=ReadFileLine(hFile, 4096);
	fclose(hFile);
	}
return CommentText;
}

CString CUploadedFiles_Item::GetMd5String()
{
FILE *hFile;
CString Md5FileName, Md5Text;

Md5FileName.Format("%s/%s.md5", (const char *)Path, (const char *)FileName);
hFile=fopen((const char *)Md5FileName, "rt");
if (hFile != NULL)
	{
	Md5Text=ReadFileLine(hFile, 4096);
	fclose(hFile);
	}
return Md5Text;
}

CConfig CUploadedFiles_Item::GetSecretItems()
{
CString CgiFileName;
CConfig Config;

CgiFileName.Format("%s/%s.cgi", (const char *)Path, (const char *)FileName);
Config.Open(CgiFileName);
return Config;
}

CString CUploadedFiles_Item::ReadFileLine(FILE *hFile, int MaxLength)
{
CString Line;
int ch;

Line="";
while ((ch=fgetc(hFile)) != EOF)
	{
	if ((ch == 13)||(ch == 10))
		{
		// CR+LF̉sR[hȂ̂
		if (ch == 13)
			{
			ch=fgetc(hFile);
			if (ch != 10) ungetc(ch, hFile); // LFł͂Ȃ̂Ŗ߂
			}
		break;
		}

	Line+=(char)ch;
	if (Line.Length >= MaxLength) break;
	}

return Line;
}

CUploadedFiles::CUploadedFiles()
{
Items.RemoveAll();
}

CUploadedFiles::~CUploadedFiles()
{
Items.RemoveAll();
}

// private function
int CUploadedFiles::LastModifiedCompare_NewFileFirst(CUploadedFiles_Item *Item1, CUploadedFiles_Item *Item2)
{
if (Item1->LastModificationTime > Item2->LastModificationTime)
	return -1;
else if (Item1->LastModificationTime < Item2->LastModificationTime)
	return 1;
else	return 0;
}

void CUploadedFiles::Open(CString TargetDirectory)
{
DIR *dir;
struct dirent *dirent;
CUploadedFiles_Item Item;
struct stat st;
CString FileNamePath, Tmp;
int i, j, k;

dir=opendir((const char *)TargetDirectory);
if (dir == NULL)
	throw(CException(CException::CErrorTypeErrorCode, errno, "CUploadedFiles::Open"));

rewinddir(dir);
while ((dirent=readdir(dir)) != NULL)
	{
	Item.iInodeNumber=dirent->d_ino;
	// Item.iOffset=dirent->d_off;
	Item.Path=TargetDirectory;
	Item.FileName=dirent->d_name;

	// Xe[^X𓾂
	FileNamePath.Format("%s/%s", (const char *)TargetDirectory, (const char *)Item.FileName);
	if (stat((const char *)FileNamePath, &st) == -1) continue; // G[͖
	Item.FileSize=st.st_size;
	Item.LastAccessTime.SetDateAndTime(st.st_atime, 0);
	Item.LastModificationTime.SetDateAndTime(st.st_mtime, 0);
	Item.LastChangeTime.SetDateAndTime(st.st_ctime, 0);
	Item.Permission=st.st_mode;

	// t@CȊOȂΏO
	if (!S_ISREG(st.st_mode)) continue;

	// "." Ŏn܂t@CO
	Tmp=Item.FileName.Left(1);
	if (Tmp == (char *)".") continue;

	// "." 2ȏ゠t@CO
	if (Item.FileName.Find('.') >= 0)
		{
		if (Item.FileName.Find('.', Item.FileName.Find('.')+1) >= 0)
			continue;	// t@Cꗗɓo^Ȃ
		}

	// ACeǉ
	Items.Add(Item);
	}

// iVÂjɃ\[g
Items.QuickSort(&LastModifiedCompare_NewFileFirst);

closedir(dir);
}
