#ifndef	CTime_defined
#define	CTime_defined

#include <time.h>
#include <sys/time.h>
#include <stdlib.h>
#include "CString.h"

class CTime
{
public:
	// constructor
	CTime();
	CTime(CTime& srcTime);
	CTime(time_t srcTime, int IsLocalTime=0);			// see "time.h"
	CTime(struct tm *srcTime, int IsLocalTime=0);		// see "time.h"
	CTime(struct timeval *srcTime, int IsLocalTime=0);	// see "sys/time.h"
	CTime(CString srcTime, int IsLocalTime=1);		// see "time.h"

	// static methods
	static int IsLeapYear(int Year);
	static int GetDaysOfYear(int Year);
	static int GetDaysOfMonth(int Year, int Month);
	static int GetDayOfWeek(int Year, int Month, int Day);
	static int GetYearDayNumber(int Year, int Month, int Day);
	static int GetDiffDays(int FirstYear, int FirstMonth, int FirstDay,
		int SecondYear, int SecondMonth, int SecondDay);
	static long long int GetDiffSec(CTime *First, CTime *Second);
	static long long int GetDiffMillisec(CTime *First, CTime *Second);
	static long long int GetDiffMicrosec(CTime *First, CTime *Second);

	// methods
	void ToLocalTime();
	void ToUniversalTime();
	void SetDateAndTimeLocalCurrent();
	void SetDateAndTime(CTime& srcTime);
	void SetDateAndTime(time_t srcTime, int srcIsLocalTime=1);		// see "time.h"
	void SetDateAndTime(struct tm *srcTime, int srcIsLocalTime=1);		// see "time.h"
	void SetDateAndTime(struct timeval *srcTime, int srcIsLocalTime=1);	// see "sys/time.h"
	void SetDateAndTime(CString srcTime, int srcIsLocalTime=1);	// see "time.h"

	void SetDate(int srcYear, int srcMonth, int srcDay);
	void SetTime(int srcHour, int srcMinute, int srcSecond,
		int srcMilliseconds=0, int srcMicroseconds=0);

	void AddYear(int aYear);
	void AddMonth(int aMonth);
	void AddDay(int aDay);
	void AddHour(int aHour);
	void AddMinute(int aMinute);
	void AddSecond(int aSecond);
	void AddMilliseconds(int aMilliseconds);
	void AddMicroseconds(int aMicroseconds);

	void AddDate(int aYear, int aMonth, int aDay);
	void AddTime(int aHour, int aMinute, int aSecond, int aMilliseconds);

	int IsLeapYear();
	int GetDaysOfYear();
	int GetDaysOfMonth();
	int GetDayOfWeek();
	int GetYearDayNumber();

	void CopyToTM(struct tm *LocalTime);

	CString ToCString(CString FormatString);
	operator time_t();

	CTime& operator=(const CTime &timeSrcLocal);
	CTime& operator=(const time_t timeSrcLocal);
	CTime& operator=(const struct tm *timeSrcLocal);
	CTime& operator=(const struct timeval *timeSrcLocal);
	CTime& operator=(const CString &timeSrcLocal);

	int operator<(CTime &time2);
	int operator>(CTime &time2);
	int operator<=(CTime &time2);
	int operator>=(CTime &time2);
	int operator==(CTime &time2);
	int operator!=(CTime &time2);

	// destructor
	~CTime();

	// properties (must be stored as local time)
	int Year, Month, Day;
	int Hour, Minute, Second, Milliseconds, Microseconds;

	// self testing
	#ifdef CCLASSDEBUG
	static void SelfTest();
	#endif
};

#endif
