#include "CTime.h"

// constructor
CTime::CTime()
{
SetDateAndTimeLocalCurrent();
}

CTime::CTime(CTime& srcTime)
{
SetDateAndTime(srcTime);
}

CTime::CTime(time_t srcTime, int srcIsLocalTime)
{
SetDateAndTime(srcTime, srcIsLocalTime);
}

CTime::CTime(struct tm *srcTime, int srcIsLocalTime)
{
SetDateAndTime(srcTime, srcIsLocalTime);
}

CTime::CTime(struct timeval *srcTime, int srcIsLocalTime)
{
SetDateAndTime(srcTime, srcIsLocalTime);
}

CTime::CTime(CString srcTime, int srcIsLocalTime)
{
SetDateAndTime(srcTime, srcIsLocalTime);
}

int CTime::IsLeapYear(int Year)
{
// 4Ŋ؂NłA
// 100Ŋ؂400Ŋ؂ȂNB
if ((Year%4) == 0)
	{
	if ( ((Year%100) == 0)&&((Year%400) > 0) ) return 0;
	else return 1;
	}
else return 0;
}

// static methods
int CTime::GetDaysOfYear(int Year)
{
if (IsLeapYear(Year) == 1) return 366;
else return 365;
}

int CTime::GetDaysOfMonth(int Year, int Month)
{
int DaysOfMonth[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

if (Month == 2)
	{
	// 2͉[N̉e󂯂
	if (IsLeapYear(Year) == 1)
		{
		if ((Month > 0)&&(Month <= 12))
			return (DaysOfMonth[Month-1]+1);
		else	return -1;
		}
	else	{
		if ((Month > 0)&&(Month <= 12))
			return (DaysOfMonth[Month-1]);
		else	return -1;
		}
	}
else	{
	// ȊO͉[N̉e󂯂Ȃ
	if ((Month > 0)&&(Month <= 12))
		return (DaysOfMonth[Month-1]);
	else	return -1;
	}
}

int CTime::GetDayOfWeek(int Year, int Month, int Day)
{
int DayOfWeek;
int i;

DayOfWeek=6;	// 0N1/1͓yj
for(i=0;i<Year;i++)
	{
	DayOfWeek+=GetDaysOfYear(i);
	DayOfWeek%=7;
	}

DayOfWeek+=GetYearDayNumber(Year, Month, Day);
DayOfWeek%=7;

return DayOfWeek;
}

// 1/10ƂԍԂ
int CTime::GetYearDayNumber(int Year, int Month, int Day)
{
int DayNumber;
int i;
int dayofmonth;

DayNumber=Day-1;
for(i=1;i<Month;i++)
	{
	dayofmonth=GetDaysOfMonth(Year, i);
	if (dayofmonth < 1) break;
	DayNumber+=dayofmonth;
	}

return DayNumber;
}

// ̓t̍ijԂ
int CTime::GetDiffDays(int FirstYear, int FirstMonth, int FirstDay, int SecondYear, int SecondMonth, int SecondDay)
{
int DiffDay;
int i;

DiffDay=GetYearDayNumber(SecondYear, SecondMonth, SecondDay)
	-GetYearDayNumber(FirstYear, FirstMonth, FirstDay);
if (FirstYear > SecondYear)
	{
	for(i=SecondYear;i<FirstYear;i++) DiffDay-=GetDaysOfYear(i);
	}
else	{
	for(i=FirstYear;i<SecondYear;i++) DiffDay+=GetDaysOfYear(i);
	}
return DiffDay;
}

// 2̎̍Ԃ
long long int CTime::GetDiffSec(CTime *First, CTime *Second)
{
long long int DiffTime;

DiffTime=(long long int unsigned)(GetDiffDays(First->Year, First->Month, First->Day,
	Second->Year, Second->Month, Second->Day));
DiffTime*=24;
DiffTime+=(Second->Hour-First->Hour);
DiffTime*=60;
DiffTime+=(Second->Minute-First->Minute);
DiffTime*=60;
DiffTime+=(Second->Second-First->Second);
return DiffTime;
}

long long int CTime::GetDiffMillisec(CTime *First, CTime *Second)
{
long long int DiffTime;

DiffTime=GetDiffSec(First, Second);
DiffTime*=1000;
DiffTime+=(Second->Milliseconds-First->Milliseconds);
return DiffTime;
}

// 2̎̍Ԃ
long long int CTime::GetDiffMicrosec(CTime *First, CTime *Second)
{
long long int DiffTime;

DiffTime=GetDiffMillisec(First, Second);
DiffTime*=1000;
DiffTime+=(Second->Microseconds-First->Microseconds);
return DiffTime;
}

void CTime::ToLocalTime()
{
struct timeval tv;
struct timezone tz;

// retrieve timezone info.
gettimeofday(&tv, &tz);
// decrement timezone
AddMinute(-tz.tz_minuteswest);
}

void CTime::ToUniversalTime()
{
struct timeval tv;
struct timezone tz;

// retrieve timezone info.
gettimeofday(&tv, &tz);
// decrement timezone
AddMinute(tz.tz_minuteswest);
}

void CTime::SetDateAndTimeLocalCurrent()
{
struct timeval tv;
struct timezone tz;

// initialize to current local time
gettimeofday(&tv, &tz);
SetDateAndTime(&tv);
ToLocalTime();
}

void CTime::SetDateAndTime(CTime& srcTime)
{
Year=srcTime.Year;
Month=srcTime.Month;
Day=srcTime.Day;
Hour=srcTime.Hour;
Minute=srcTime.Minute;
Second=srcTime.Second;
Milliseconds=srcTime.Milliseconds;
Microseconds=srcTime.Microseconds;
}

void CTime::SetDateAndTime(time_t srcTime, int srcIsLocalTime)
{
Year=1970;
Month=1;
Day=1;
Hour=0;
Minute=0;
Second=0;
Milliseconds=0;
Microseconds=0;

AddSecond(srcTime);

if (srcIsLocalTime == 0) ToLocalTime();
}

void CTime::SetDateAndTime(struct tm *srcTime, int srcIsLocalTime)
{
Year=srcTime->tm_year+1900;
Month=srcTime->tm_mon+1;
Day=srcTime->tm_mday;
Hour=srcTime->tm_hour;
Minute=srcTime->tm_min;
Second=srcTime->tm_sec;
Milliseconds=0;
Microseconds=0;

if (srcIsLocalTime == 0) ToLocalTime();
}

void CTime::SetDateAndTime(struct timeval *srcTime, int srcIsLocalTime)
{
Year=1970;
Month=1;
Day=1;
Hour=0;
Minute=0;
Second=0;
Milliseconds=0;
Microseconds=0;

AddSecond(srcTime->tv_sec);
AddMicroseconds(srcTime->tv_usec);

if (srcIsLocalTime == 0) ToLocalTime();
}

void CTime::SetDateAndTime(CString srcTime, int srcIsLocalTime)
{
char *p, *q;
char buf[256];
int i;

// "yyyy/mm/dd hh:mm:ss.nnnnnn" style input

// year
p=(char *)(const char *)srcTime;
q=p;
while (((*q != '/')&&(*q != ':'))&&(((*q != '.')&&(*q != ' '))&&(*q != 0))) q++;
strncpy(buf, p, min((int)(q-p), 256));
buf[min((int)(q-p), 255)]=0;
Year=atoi(buf);

// month
p=q; while ((*p == '/')||(*p == ':')||(*p == '.')||(*p == ' ')) p++;
q=p;
while (((*q != '/')&&(*q != ':'))&&(((*q != '.')&&(*q != ' '))&&(*q != 0))) q++;
strncpy(buf, p, min((int)(q-p), 256));
buf[min((int)(q-p), 255)]=0;
Month=atoi(buf);

// day
p=q; while ((*p == '/')||(*p == ':')||(*p == '.')||(*p == ' ')) p++;
q=p;
while (((*q != '/')&&(*q != ':'))&&(((*q != '.')&&(*q != ' '))&&(*q != 0))) q++;
strncpy(buf, p, min((int)(q-p), 256));
buf[min((int)(q-p), 255)]=0;
Day=atoi(buf);

// hour
p=q; while ((*p == '/')||(*p == ':')||(*p == '.')||(*p == ' ')) p++;
q=p;
while (((*q != '/')&&(*q != ':'))&&(((*q != '.')&&(*q != ' '))&&(*q != 0))) q++;
strncpy(buf, p, min((int)(q-p), 256));
buf[min((int)(q-p), 255)]=0;
Hour=atoi(buf);

// minute
p=q; while ((*p == '/')||(*p == ':')||(*p == '.')||(*p == ' ')) p++;
q=p;
while (((*q != '/')&&(*q != ':'))&&(((*q != '.')&&(*q != ' '))&&(*q != 0))) q++;
strncpy(buf, p, min((int)(q-p), 256));
buf[min((int)(q-p), 255)]=0;
Minute=atoi(buf);

// second
p=q; while ((*p == '/')||(*p == ':')||(*p == '.')||(*p == ' ')) p++;
q=p;
while (((*q != '/')&&(*q != ':'))&&(((*q != '.')&&(*q != ' '))&&(*q != 0))) q++;
strncpy(buf, p, min((int)(q-p), 256));
buf[min((int)(q-p), 255)]=0;
Second=atoi(buf);

// millisecond/microsecond (max 6 digits)
p=q; while ((*p == '/')||(*p == ':')||(*p == '.')||(*p == ' ')) p++;
q=p;
while (((*q != '/')&&(*q != ':'))&&(((*q != '.')&&(*q != ' '))&&(*q != 0))) q++;
strncpy(buf, p, min((int)(q-p), 256));
buf[min((int)(q-p), 255)]=0;

switch (strlen(buf))
	{
	case 1:
		Milliseconds=atoi(buf)*100;
		Microseconds=0;
		break;
	case 2:
		Milliseconds=atoi(buf)*10;
		Microseconds=0;
		break;
	case 3:
		Milliseconds=atoi(buf);
		Microseconds=0;
		break;
	case 4:
		Milliseconds=atoi(buf)/10;
		Microseconds=(atoi(buf)%10)*100;
		break;
	case 5:
		Milliseconds=atoi(buf)/100;
		Microseconds=(atoi(buf)%100)*10;
		break;
	default:
		Milliseconds=atoi(buf)/1000;
		Microseconds=atoi(buf)%1000;
		break;
	}

if (srcIsLocalTime == 0) ToLocalTime();
}

void CTime::SetDate(int srcYear, int srcMonth, int srcDay)
{
Year=srcYear;
Month=srcMonth;
Day=srcDay;
}

void CTime::SetTime(int srcHour, int srcMinute, int srcSecond, int srcMilliseconds, int srcMicroseconds)
{
Hour=srcHour;
Minute=srcMinute;
Second=srcSecond;
Milliseconds=srcMilliseconds;
Microseconds=srcMicroseconds;
}

void CTime::AddYear(int aYear)
{
Year+=aYear;
}

void CTime::AddMonth(int aMonth)
{
Month+=aMonth;

while (Month > 12) { AddYear(1); Month-=12; }
while (Month < 1) { AddYear(-1); Month+=12; }
}

void CTime::AddDay(int aDay)
{
Day+=aDay;

while (Day > GetDaysOfMonth(Year, Month)) { Day-=GetDaysOfMonth(Year, Month); AddMonth(1); }
while (Day < 1) { AddMonth(-1); Day+=GetDaysOfMonth(Year, Month); }
}

void CTime::AddHour(int aHour)
{
// 24Ŋ̂ɗ
AddDay(aHour/24);

// ]̂ǉ
Hour+=(aHour-(aHour/24)*24);

// 
while (Hour > 23) { Hour-=24; AddDay(1); }
while (Hour < 0) { Hour+=24; AddDay(-1); }
}

void CTime::AddMinute(int aMinute)
{
// 60Ŋ̂ɗ
AddHour(aMinute/60);

// ]̂ǉ
Minute+=(aMinute-(aMinute/60)*60);

// 
while (Minute > 59) { Minute-=60; AddHour(1); }
while (Minute < 0) { Minute+=60; AddHour(-1); }
}

void CTime::AddSecond(int aSecond)
{
// 60Ŋ̂𕪂ɗ
AddMinute(aSecond/60);

// ]̂ǉ
Second+=(aSecond-(aSecond/60)*60);

// 
while (Second > 59) { Second-=60; AddMinute(1); }
while (Second < 0) { Second+=60; AddMinute(-1); }
}

void CTime::AddMilliseconds(int aMilliseconds)
{
// 1000Ŋ̂bɗ
AddSecond(aMilliseconds/1000);

// ]̂ǉ
Milliseconds+=(aMilliseconds-(aMilliseconds/1000)*1000);

// 
while (Milliseconds > 999) { Milliseconds-=1000; AddSecond(1); }
while (Milliseconds < 0) { Milliseconds+=1000; AddSecond(-1); }
}

void CTime::AddMicroseconds(int aMicroseconds)
{
// 1000Ŋ̂~bɗ
AddMilliseconds(aMicroseconds/1000);

// ]̂ǉ
Microseconds+=(aMicroseconds-(aMicroseconds/1000)*1000);

// 
while (Microseconds > 999) { Microseconds-=1000; AddMilliseconds(1); }
while (Microseconds < 0) { Microseconds+=1000; AddMilliseconds(-1); }
}

void CTime::AddDate(int aYear, int aMonth, int aDay)
{
AddYear(aYear);
AddMonth(aMonth);
AddDay(aDay);
}

void CTime::AddTime(int aHour, int aMinute, int aSecond, int aMilliseconds)
{
AddHour(aHour);
AddMinute(aMinute);
AddSecond(aSecond);
AddMilliseconds(aMilliseconds);
}

int CTime::IsLeapYear()
{
return IsLeapYear(Year);
}

int CTime::GetDaysOfYear()
{
return GetDaysOfYear(Year);
}

int CTime::GetDaysOfMonth()
{
return GetDaysOfMonth(Year, Month);
}

int CTime::GetDayOfWeek()
{
return GetDayOfWeek(Year, Month, Day);
}

int CTime::GetYearDayNumber()
{
return GetYearDayNumber(Year, Month, Day);
}

void CTime::CopyToTM(struct tm *destTime)
{
destTime->tm_sec=Second;
destTime->tm_min=Minute;
destTime->tm_hour=Hour;
destTime->tm_mday=Day;
destTime->tm_mon=Month-1;
destTime->tm_year=Year-1900;
destTime->tm_wday=CTime::GetDayOfWeek(Year, Month, Day);
destTime->tm_yday=CTime::GetYearDayNumber(Year, Month, Day);
destTime->tm_isdst=0;
}

CString CTime::ToCString(CString FormatString)
{
char buffer[256];
struct tm timeval;
CString Str;

if (FormatString.Length > 0)
	{
	CopyToTM(&timeval);
	memset((void *)buffer, 0, sizeof(char)*256);
	strftime(buffer, 256, (const char *)FormatString, &timeval);
	Str=buffer;
	}
else	{
	Str.Format("%04i/%02i/%02i %02i:%02i:%02i.%03i%03i",
		Year, Month, Day, Hour, Minute, Second, Milliseconds, Microseconds);
	}
return Str;
}

CTime::operator time_t()
{
struct tm tim;
struct timeval tv;
struct timezone tz;

// retrieve timezone info.
gettimeofday(&tv, &tz);

// struct tmɃRs[
CopyToTM(&tim);
// timezone
return mktime(&tim); //-(tz.tz_minuteswest*60);
}

CTime& CTime::operator=(const CTime &timeSrc)
{
// copy
(*this).SetDate(timeSrc.Year, timeSrc.Month, timeSrc.Day);
(*this).SetTime(timeSrc.Hour, timeSrc.Minute, timeSrc.Second,
	timeSrc.Milliseconds, timeSrc.Microseconds);

return *this;
}

CTime& CTime::operator=(const time_t timeSrcLocal)
{
// copy
(*this).SetDateAndTime(timeSrcLocal, 1);
return (*this);
}

CTime& CTime::operator=(const struct tm *timeSrcLocal)
{
// copy
(*this).SetDateAndTime((struct tm *)timeSrcLocal, 1);
return (*this);
}

CTime& CTime::operator=(const struct timeval *timeSrcLocal)
{
// copy
(*this).SetDateAndTime((struct timeval *)timeSrcLocal, 1);
return (*this);
}

CTime& CTime::operator=(const CString &timeSrcLocal)
{
// copy
(*this).SetDateAndTime(timeSrcLocal, 1);
return (*this);
}

int CTime::operator<(CTime &time2)
{
// Pɏォ珇ɏׂ
if (Year < time2.Year) return 1;
else if (Year > time2.Year) return 0;
else if (Month < time2.Month) return 1;
else if (Month > time2.Month) return 0;
else if (Day < time2.Day) return 1;
else if (Day > time2.Day) return 0;
else if (Hour < time2.Hour) return 1;
else if (Hour > time2.Hour) return 0;
else if (Minute < time2.Minute) return 1;
else if (Minute > time2.Minute) return 0;
else if (Second < time2.Second) return 1;
else if (Second > time2.Second) return 0;
else if (Milliseconds < time2.Milliseconds) return 1;
else if (Milliseconds > time2.Milliseconds) return 0;
else if (Microseconds < time2.Microseconds) return 1;
else if (Microseconds > time2.Microseconds) return 0;
else	return 0;
}

int CTime::operator>(CTime &time2)
{
// Pɏォ珇ɏׂ
if (Year < time2.Year) return 0;
else if (Year > time2.Year) return 1;
else if (Month < time2.Month) return 0;
else if (Month > time2.Month) return 1;
else if (Day < time2.Day) return 0;
else if (Day > time2.Day) return 1;
else if (Hour < time2.Hour) return 0;
else if (Hour > time2.Hour) return 1;
else if (Minute < time2.Minute) return 0;
else if (Minute > time2.Minute) return 1;
else if (Second < time2.Second) return 0;
else if (Second > time2.Second) return 1;
else if (Milliseconds < time2.Milliseconds) return 0;
else if (Milliseconds > time2.Milliseconds) return 1;
else if (Microseconds < time2.Microseconds) return 0;
else if (Microseconds > time2.Microseconds) return 1;
else	return 0;
}

int CTime::operator<=(CTime &time2)
{
// Pɏォ珇ɏׂ
if (Year < time2.Year) return 1;
else if (Year > time2.Year) return 0;
else if (Month < time2.Month) return 1;
else if (Month > time2.Month) return 0;
else if (Day < time2.Day) return 1;
else if (Day > time2.Day) return 0;
else if (Hour < time2.Hour) return 1;
else if (Hour > time2.Hour) return 0;
else if (Minute < time2.Minute) return 1;
else if (Minute > time2.Minute) return 0;
else if (Second < time2.Second) return 1;
else if (Second > time2.Second) return 0;
else if (Milliseconds < time2.Milliseconds) return 1;
else if (Milliseconds > time2.Milliseconds) return 0;
else if (Microseconds < time2.Microseconds) return 1;
else if (Microseconds > time2.Microseconds) return 0;
else	return 1;
}

int CTime::operator>=(CTime &time2)
{
// Pɏォ珇ɏׂ
if (Year < time2.Year) return 0;
else if (Year > time2.Year) return 1;
else if (Month < time2.Month) return 0;
else if (Month > time2.Month) return 1;
else if (Day < time2.Day) return 0;
else if (Day > time2.Day) return 1;
else if (Hour < time2.Hour) return 0;
else if (Hour > time2.Hour) return 1;
else if (Minute < time2.Minute) return 0;
else if (Minute > time2.Minute) return 1;
else if (Second < time2.Second) return 0;
else if (Second > time2.Second) return 1;
else if (Milliseconds < time2.Milliseconds) return 0;
else if (Milliseconds > time2.Milliseconds) return 1;
else if (Microseconds < time2.Microseconds) return 0;
else if (Microseconds > time2.Microseconds) return 1;
else	return 1;
}

int CTime::operator==(CTime &time2)
{
// Pɏォ珇ɏׂ
if (Year != time2.Year) return 0;
else if (Month != time2.Month) return 0;
else if (Day != time2.Day) return 0;
else if (Hour != time2.Hour) return 0;
else if (Minute != time2.Minute) return 0;
else if (Second != time2.Second) return 0;
else if (Milliseconds != time2.Milliseconds) return 0;
else if (Microseconds != time2.Microseconds) return 0;
else	return 1;
}

int CTime::operator!=(CTime &time2)
{
// Pɏォ珇ɏׂ
if (Year != time2.Year) return 1;
else if (Month != time2.Month) return 1;
else if (Day != time2.Day) return 1;
else if (Hour != time2.Hour) return 1;
else if (Minute != time2.Minute) return 1;
else if (Second != time2.Second) return 1;
else if (Milliseconds != time2.Milliseconds) return 1;
else if (Microseconds != time2.Microseconds) return 1;
else	return 0;
}

CTime::~CTime()
{
// do nothing
}

// self testing
#ifdef CCLASSDEBUG
void CTime::SelfTest()
{
CTime Time1, Time2;
time_t stime;
struct timeval tv;
struct timezone tz;

printf("Self testing CTime() class..\n");

printf("  Step1. constructor & method test.\n");
printf("    Current time = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);
Time1.SetDateAndTime(time(NULL));
printf("    Current time from time_t = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);
stime=time(NULL);
Time1.SetDateAndTime(localtime(&stime), 1);
printf("    Current time from struct tm* = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);
gettimeofday(&tv, &tz);
Time1.SetDateAndTime(&tv);
printf("    Current time from struct timeval* = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);
Time1.SetDateAndTime((CString)"2002/12/23 23:34:45.678901");
printf("    Other time from CString = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);

printf("  Step2. static method test.\n");
Time1.SetDateAndTimeLocalCurrent();
printf("    Current time = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);
Time2.SetDate(1900, 1, 1);
Time2.SetTime(0, 0, 0, 0, 0);
printf("    days from 1900/01/01 = %i\n",
	CTime::GetDiffDays(Time2.Year, Time2.Month, Time2.Day,
		Time1.Year, Time1.Month, Time1.Day));
printf("    seconds from 1950/01/01 = %lli\n",
	CTime::GetDiffSec(&Time2, &Time1));

printf("  Step3. method test.\n");
Time1.SetDateAndTimeLocalCurrent();
Time1.AddDay(90);
printf("    90 days after from now = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);
Time1.SetDateAndTimeLocalCurrent();
Time1.AddMonth(13);
printf("    13 months after from now = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);
Time1.SetDateAndTimeLocalCurrent();
Time1.AddSecond(6000);
printf("    6000 seconds after from now = %04i/%02i/%02i %02i:%02i:%02i.%03i%03i\n",
	Time1.Year, Time1.Month, Time1.Day,
	Time1.Hour, Time1.Minute, Time1.Second,
	Time1.Milliseconds, Time1.Microseconds);

printf("Self testing CTime() completed.\n");
}
#endif
