#ifndef CString_defined
#define CString_defined

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

typedef int CChar;

#define CString_MallocEach		32
#define	CString_HardCodedMaxLength	4096

#define	min(a,b)	((a>b)?b:a)
#define	max(a,b)	((a>b)?a:b)

class CString
{
public:
	// constructors
	CString();
	CString(const CString& srcString);
	CString(char srcChar, int RepeatCount=1);
	CString(char *srcCharArray, int srcCharArrayLength=-1, int RepeatCount=1);
	CString(CChar srcChar, int RepeatCount=1);
	CString(CChar *srcCharArray, int srcCharArrayLength=-1, int RepeatCount=1);
	CString(CString& srcString, int RepeatCount=1);

	// destructor
	~CString();

	// static methods
	static int CharArrayToCCharArray(const char *srcCharArray, int srcCharArrayLength,
		CChar **destCharArray);
	static int CCharArrayToCharArray(const CChar *srcCharArray, int srcCharArrayLength,
		char **destCharArray);
	static int CompareChar(CChar srcChar1, CChar srcChar2, int bIgnoreCase=1);
	static int CCharArrayUpper(CChar *srcCharArray, int srcCharArrayLength,
		CChar **destCharArray);
	static int CCharArrayLower(CChar *srcCharArray, int srcCharArrayLength,
		CChar **destCharArray);
	static CChar CharToCChar(char srcChar);
	static char CCharToChar(CChar srcChar);

	// methods
	void Empty();
	void Insert(int InsertPos, char srcChar, int RepeatCount=1);
	void Insert(int InsertPos, char *srcCharArray, int srcCharArrayLength=-1, int RepeatCount=1);
	void Insert(int InsertPos, CChar srcChar, int RepeatCount=1);
	void Insert(int InsertPos, CChar *srcCharArray, int srcCharArrayLength=-1, int RepeatCount=1);
	void Insert(int InsertPos, const CString& srcString, int RepeatCount=1);
	void Delete(int iIndex, int iCount=1);
	int Find(char srcChar, int iStart=0, int bIgnoreCase=1, int bDirection=1);
	int Find(char *srcCharArray, int srcCharArrayLength=-1, int iStart=0, int bIgnoreCase=1, int bDirection=1);
	int Find(CChar srcChar, int iStart=0, int bIgnoreCase=1, int bDirection=1);
	int Find(CChar *srcCharArray, int srcCharArrayLength=-1, int iStart=0, int bIgnoreCase=1, int bDirection=1);
	int Find(CString& srcString, int iStart=0, int bIgnoreCase=1, int bDirection=1);
	int FindOneOf(char *srcCharArray, int srcCharArrayLength=-1, int iStart=0, int bIgnoreCase=1);
	int FindOneOf(CChar *srcCharArray, int srcCharArrayLength=-1, int iStart=0, int bIgnoreCase=1);
	int FindOneOf(CString& srcString, int iStart=0, int bIgnoreCase=1);

	void Format(const char *srcFormatString, ...);
	void Format(const char *srcFormatString, va_list srcFormatString);
	void InsertFormat(int InsertPos, const char *srcFormatString, ...);
	void InsertFormat(int InsertPos, const char *srcFormatString, va_list srcFormatString);

	int Compare(CString& destString, int bIgnoreCase=1);
	int Compare(const char destChar, int bIgnoreCase=1);
	int Compare(const char *destCharArray, int srcCharArrayLength=-1, int bIgnoreCase=1);
	int Compare(const CChar destChar, int bIgnoreCase=1);
	int Compare(const CChar *destCharArray, int srcCharArrayLength=-1, int bIgnoreCase=1);

	CChar GetAt(int iIndex);
	void SetAt(int iIndex, CChar srcChar);
	int IsEmpty();

	CString Left(int iCount);
	CString Mid(int iStart, int iLength=-1);
	CString Right(int iCount);
	CString Lower();
	CString Upper();
	CString Reverse();

	CString Remove(char srcChar, int bIgnoreCase=1);
	CString Remove(CChar srcChar, int bIgnoreCase=1);
	CString Remove(char *srcCharArray, int srcCharArrayLength=-1, int bIgnoreCase=1);
	CString Remove(CChar *srcCharArray, int srcCharArrayLength=-1, int bIgnoreCase=1);
	CString Remove(CString& srcString, int bIgnoreCase=1);

	CString Replace(char *oldString, int oldStringLength, char *newString, int newStringLength);
	CString Replace(CChar *oldString, int oldStringLength, CChar *newString, int newStringLength);
	CString Replace(char *oldString, char *newString);
	CString Replace(CChar *oldString, CChar *newString);
	CString Replace(CString& oldString, CString& newString);

	// Tokenize()
	CString TrimLeft(char srcChar=' ');
	CString TrimLeft(CChar srcChar);
	CString TrimRight(char srcChar=' ');
	CString TrimRight(CChar srcChar);
	CString Trim(char srcChar=' ');
	CString Trim(CChar srcChar);

	// HTML^OƂĔF\̂镶GR[h^fR[h
	CString EncodeIllegalHtmlChar();
	CString DecodeIllegalHtmlChar();

	// URIGR[h^fR[h
	CString EncodeURI();
	CString DecodeURI();

	// operators
	CString& operator=(const CString& srcString);
	CString& operator=(const char srcChar);
	CString& operator=(const char *srcString);
	CString& operator=(const CChar srcChar);
	CString& operator=(const CChar *srcString);

	CString& operator+=(const CString& srcString);
	CString& operator+=(const char srcChar);
	CString& operator+=(const char *srcString);
	CString& operator+=(const CChar srcChar);
	CString& operator+=(const CChar *srcString);

	friend CString operator+(const CString& srcString1, const CString& srcString2);
	friend CString operator+(const CString& srcString1, const char srcChar2);
	friend CString operator+(const CString& srcString1, const char *srcString2);
	friend CString operator+(const CString& srcString1, const CChar srcChar2);
	friend CString operator+(const CString& srcString1, const CChar *srcString2);
	friend CString operator+(const char srcChar1, const CString& srcString2);
	friend CString operator+(const char *srcString1, const CString& srcString2);
	friend CString operator+(const CChar srcChar1, const CString& srcString2);
	friend CString operator+(const CChar *srcString1, const CString& srcString2);

	friend int operator==(CString srcString1, CString srcString2);
	friend int operator==(CString srcString1, const char srcChar2);
	friend int operator==(CString srcString1, const char *srcString2);
	friend int operator==(CString srcString1, const CChar srcChar2);
	friend int operator==(CString srcString1, const CChar *srcString2);
	friend int operator==(const char srcChar1, CString srcString2);
	friend int operator==(const char *srcString1, CString srcString2);
	friend int operator==(const CChar srcChar1, CString srcString2);
	friend int operator==(const CChar *srcString1, CString srcString2);

	friend int operator!=(CString srcString1, CString srcString2);
	friend int operator!=(CString srcString1, const char srcChar2);
	friend int operator!=(CString srcString1, const char *srcString2);
	friend int operator!=(CString srcString1, const CChar srcChar2);
	friend int operator!=(CString srcString1, const CChar *srcString2);
	friend int operator!=(const char srcChar1, CString srcString2);
	friend int operator!=(const char *srcString1, CString srcString2);
	friend int operator!=(const CChar srcChar1, CString srcString2);
	friend int operator!=(const CChar *srcString1, CString srcString2);

	friend int operator>=(CString srcString1, CString srcString2);
	friend int operator>=(CString srcString1, const char srcChar2);
	friend int operator>=(CString srcString1, const char *srcString2);
	friend int operator>=(CString srcString1, const CChar srcChar2);
	friend int operator>=(CString srcString1, const CChar *srcString2);
	friend int operator>=(const char srcChar1, const CString srcString2);
	friend int operator>=(const char *srcString1, const CString srcString2);
	friend int operator>=(const CChar srcChar1, const CString srcString2);
	friend int operator>=(const CChar *srcString1, const CString srcString2);

	friend int operator<=(CString srcString1, CString srcString2);
	friend int operator<=(CString srcString1, const char srcChar2);
	friend int operator<=(CString srcString1, const char *srcString2);
	friend int operator<=(CString srcString1, const CChar srcChar2);
	friend int operator<=(CString srcString1, const CChar *srcString2);
	friend int operator<=(const char srcChar1, CString srcString2);
	friend int operator<=(const char *srcString1, CString srcString2);
	friend int operator<=(const CChar srcChar1, CString srcString2);
	friend int operator<=(const CChar *srcString1, CString srcString2);

	friend int operator>(CString srcString1, CString srcString2);
	friend int operator>(CString srcString1, const char srcChar2);
	friend int operator>(CString srcString1, const char *srcString2);
	friend int operator>(CString srcString1, const CChar srcChar2);
	friend int operator>(CString srcString1, const CChar *srcString2);
	friend int operator>(const char srcChar1, CString srcString2);
	friend int operator>(const char *srcString1, CString srcString2);
	friend int operator>(const CChar srcChar1, CString srcString2);
	friend int operator>(const CChar *srcString1, CString srcString2);

	friend int operator<(CString srcString1, CString srcString2);
	friend int operator<(CString srcString1, const char srcChar2);
	friend int operator<(CString srcString1, const char *srcString2);
	friend int operator<(CString srcString1, const CChar srcChar2);
	friend int operator<(CString srcString1, const CChar *srcString2);
	friend int operator<(const char srcChar1, CString srcString2);
	friend int operator<(const char *srcString1, CString srcString2);
	friend int operator<(const CChar srcChar1, CString srcString2);
	friend int operator<(const CChar *srcString1, CString srcString2);

	CChar operator[](int iIndex);
	operator const CChar *();
	operator const char *();

	// private methods
	void ReallocBuffer(int requestedLength);

	// self testing
	#ifdef CCLASSDEBUG
	void Dump();
	static void SelfTest();
	#endif

	// properties
	int Length;
	CChar *StringData;
	char *StringDataCharArray;	// temporary buffer; must be freed after StringData update

	int BufferLength;
};

#endif
