#include "CString.h"

// constructors
CString::CString()
{
Length=0;
StringData=NULL;
BufferLength=0;
StringDataCharArray=NULL;
}

CString::CString(const CString& srcString)
{
Length=0;
StringData=NULL;
BufferLength=0;
StringDataCharArray=NULL;

Insert(0, srcString.StringData, srcString.Length, 1);
}

// constructors
CString::CString(char srcChar, int RepeatCount)
{
Length=0;
StringData=NULL;
BufferLength=0;
StringDataCharArray=NULL;

Insert(0, srcChar, RepeatCount);
}

// constructors
CString::CString(char *srcCharArray, int srcCharArrayLength, int RepeatCount)
{
Length=0;
StringData=NULL;
BufferLength=0;
StringDataCharArray=NULL;

Insert(0, srcCharArray, srcCharArrayLength, RepeatCount);
}

// constructors
CString::CString(CChar srcChar, int RepeatCount)
{
Length=0;
StringData=NULL;
BufferLength=0;
StringDataCharArray=NULL;

Insert(0, srcChar, RepeatCount);
}

// constructors
CString::CString(CChar *srcCharArray, int srcCharArrayLength, int RepeatCount)
{
Length=0;
StringData=NULL;
BufferLength=0;
StringDataCharArray=NULL;

Insert(0, srcCharArray, srcCharArrayLength, RepeatCount);
}

// constructors
CString::CString(CString& srcString, int RepeatCount)
{
Length=0;
StringData=NULL;
BufferLength=0;
StringDataCharArray=NULL;

Insert(0, srcString.StringData, srcString.Length, RepeatCount);
}

// destructor
CString::~CString()
{
Empty();
}

// static methods
int CString::CharArrayToCCharArray(const char *srcCharArray, int srcCharArrayLength,
	CChar **destCharArray)
{
int ArrayLength;
int i;

if (srcCharArrayLength >= 0)
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (srcCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}

// no conversion
(*destCharArray)=(CChar *)malloc(sizeof(CChar)*(ArrayLength+1));
if ((*destCharArray) == NULL) return -1;

for(i=0;i<ArrayLength;i++)
	(*destCharArray)[i]=srcCharArray[i];
(*destCharArray)[ArrayLength]=0;

return ArrayLength;
}

// static methods
int CString::CCharArrayToCharArray(const CChar *srcCharArray, int srcCharArrayLength,
	char **destCharArray)
{
int ArrayLength;
int i;

if (srcCharArrayLength >= 0)
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (srcCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}

// no conversion
(*destCharArray)=(char *)malloc(sizeof(char)*(ArrayLength+1));
if ((*destCharArray) == NULL) return -1;

for(i=0;i<ArrayLength;i++)
	(*destCharArray)[i]=srcCharArray[i];
(*destCharArray)[ArrayLength]=0;

return ArrayLength;
}

// static methods
int CString::CompareChar(CChar srcChar1, CChar srcChar2, int bIgnoreCase)
{
switch (bIgnoreCase)
	{
	case 0:
		return srcChar1-srcChar2;
	case 1:
		return toupper(srcChar1)-toupper(srcChar2);
	}

return -1; // error
}

// static methods
int CString::CCharArrayUpper(CChar *srcCharArray, int srcCharArrayLength,
	CChar **destCharArray)
{
int ArrayLength;
int i;

if (srcCharArrayLength >= 0)
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (srcCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}

// no conversion
(*destCharArray)=(CChar *)malloc(sizeof(CChar)*ArrayLength);
if ((*destCharArray) == NULL) return -1;

for(i=0;i<ArrayLength;i++)
	(*destCharArray)[i]=(CChar)toupper((char)srcCharArray[i]);

return ArrayLength;
}

// static methods
int CString::CCharArrayLower(CChar *srcCharArray, int srcCharArrayLength,
	CChar **destCharArray)
{
int ArrayLength;
int i;

if (srcCharArrayLength >= 0)
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (srcCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}

// no conversion
(*destCharArray)=(CChar *)malloc(sizeof(CChar)*ArrayLength);
if ((*destCharArray) == NULL) return -1;

for(i=0;i<ArrayLength;i++)
	(*destCharArray)[i]=(CChar)tolower((char)srcCharArray[i]);

return ArrayLength;
}

CChar CString::CharToCChar(char srcChar)
{
return (CChar)srcChar;
}

char CString::CCharToChar(CChar srcChar)
{
return (char)srcChar;
}

// methods
void CString::Empty()
{
Length=0;
if (StringData != NULL) free(StringData);
if (StringDataCharArray != NULL) free(StringDataCharArray);
StringData=NULL;
StringDataCharArray=NULL;
BufferLength=0;
}

void CString::Insert(int InsertPos, char srcChar, int RepeatCount)
{
Insert(InsertPos, CString::CharToCChar(srcChar), RepeatCount);
}

void CString::Insert(int InsertPos, char *srcCharArray, int srcCharArrayLength, int RepeatCount)
{
CChar *srcCharArrayConverted;
int ArrayLength;

ArrayLength=CString::CharArrayToCCharArray(srcCharArray, srcCharArrayLength,
	&srcCharArrayConverted);
if (ArrayLength < 0) return;

Insert(InsertPos, srcCharArrayConverted, ArrayLength, RepeatCount);

free(srcCharArrayConverted);
}

void CString::Insert(int InsertPos, CChar srcChar, int RepeatCount)
{
int i;

// 0`InsertPos-1  ̂܂
// InsertPos`InsertPos+RepeatCount-1  srcCharŖ߂
// InsertPos+RepeatCount`Length+RepeatCount-1  ̂܂

ReallocBuffer(Length+RepeatCount);
for(i=Length+RepeatCount-1;i>=InsertPos+RepeatCount;i--) StringData[i]=StringData[i-RepeatCount];
for(i=0;i<RepeatCount;i++) StringData[i+InsertPos]=srcChar;

// clear chararray
if (StringDataCharArray != NULL)
	{
	free(StringDataCharArray);
	StringDataCharArray=NULL;
	}

Length+=RepeatCount;
}

void CString::Insert(int InsertPos, CChar *srcCharArray, int srcCharArrayLength, int RepeatCount)
{
int i, j, ArrayLength;

// 0`InsertPos-1  ̂܂
// InsertPos`InsertPos+ArrayLength*RepeatCount-1  srcCharArrayŖ߂
// InsertPos+ArrayLength*RepeatCount`Length+ArrayLength*RepeatCount-1  ̂܂

if (srcCharArrayLength >= 0)
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (srcCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}
ReallocBuffer(Length+ArrayLength*RepeatCount);
for(i=Length+ArrayLength*RepeatCount-1;i>=InsertPos+ArrayLength*RepeatCount;i--)
	StringData[i]=StringData[i-ArrayLength*RepeatCount];
for(i=0;i<RepeatCount;i++)
	for(j=0;j<ArrayLength;j++)
		StringData[i*ArrayLength+j+InsertPos]=srcCharArray[j];

// clear chararray
if (StringDataCharArray != NULL)
	{
	free(StringDataCharArray);
	StringDataCharArray=NULL;
	}

Length+=ArrayLength*RepeatCount;
}

void CString::Insert(int InsertPos, const CString& srcString, int RepeatCount)
{
Insert(InsertPos, (CChar *)srcString.StringData, srcString.Length, RepeatCount);
}

void CString::Delete(int iIndex, int iCount)
{
int i;

// 0`iIndex-1  ̂܂
// iIndex`iIndex+iCount-1  폜
// iIndex+iCount`Length-1  ̂܂

for(i=iIndex+iCount;i<Length;i++) StringData[i-iCount]=StringData[i];
ReallocBuffer(Length-iCount);
Length-=iCount;

// clear chararray
if (StringDataCharArray != NULL)
	{
	free(StringDataCharArray);
	StringDataCharArray=NULL;
	}
}

int CString::Find(char srcChar, int iStart, int bIgnoreCase, int bDirection)
{
return Find(CString::CharToCChar(srcChar), iStart, bIgnoreCase, bDirection);
}

int CString::Find(char *srcCharArray, int srcCharArrayLength, int iStart, int bIgnoreCase, int bDirection)
{
int ArrayLength;
CChar *srcCharArrayConverted;
int ret;

ArrayLength=CString::CharArrayToCCharArray(srcCharArray, srcCharArrayLength,
		&srcCharArrayConverted);
if (ArrayLength < 1) return -1;

ret=Find(srcCharArrayConverted, ArrayLength, iStart, bIgnoreCase, bDirection);
free(srcCharArrayConverted);

return ret;
}

int CString::Find(CChar srcChar, int iStart, int bIgnoreCase, int bDirection)
{
int i;

if (bDirection >= 0)
	{
	for(i=iStart;i<Length;i++)
		if (CompareChar(StringData[i], srcChar, bIgnoreCase) == 0) return i;
	}
else	{
	for(i=min(iStart, Length-1);i>=0;i--)
		if (CompareChar(StringData[i], srcChar, bIgnoreCase) == 0) return i;
	}

return -1;
}

int CString::Find(CChar *srcCharArray, int srcCharArrayLength, int iStart, int bIgnoreCase, int bDirection)
{
int i, j;
int ArrayLength;

if (srcCharArrayLength > 0)	// CR[͊܂܂Ȃ
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (srcCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}

if (ArrayLength < 1) return -1;

if (bDirection >= 0)
	{
	for(i=iStart;i<=Length-ArrayLength;i++)
		{
		if (CompareChar(StringData[i], srcCharArray[0], bIgnoreCase) == 0)
			{
			int Match;

			Match=1;
			for(j=1;j<ArrayLength;j++)
				{
				if (CompareChar(StringData[i+j], srcCharArray[j], bIgnoreCase) != 0)
					{
					Match=0;
					break;
					}
				}
			if (Match == 1) return i;
			}
		}
	}
else	{
	for(i=min(iStart, Length-ArrayLength-1);i>=0;i--)
		{
		if (CompareChar(StringData[i], srcCharArray[0], bIgnoreCase) == 0)
			{
			int Match;

			Match=1;
			for(j=1;j<ArrayLength;j++)
				{
				if (CompareChar(StringData[i+j], srcCharArray[j], bIgnoreCase) != 0)
					{
					Match=0;
					break;
					}
				}
			if (Match == 1) return i;
			}
		}
	}

return -1;
}

int CString::Find(CString& srcString, int iStart, int bIgnoreCase, int bDirection)
{
return Find(srcString.StringData, srcString.Length, iStart, bIgnoreCase, bDirection);
}

int CString::FindOneOf(char *srcCharArray, int srcCharArrayLength, int iStart, int bIgnoreCase)
{
int i, ArrayLength;
CChar *srcCharArrayConverted;
int ret;

ArrayLength=CString::CharArrayToCCharArray(srcCharArray, srcCharArrayLength,
	&srcCharArrayConverted);
if (ArrayLength < 0) return -1;

ret=FindOneOf(srcCharArrayConverted, ArrayLength, iStart, bIgnoreCase);
free(srcCharArrayConverted);

return ret;
}

int CString::FindOneOf(CChar *srcCharArray, int srcCharArrayLength, int iStart, int bIgnoreCase)
{
int i, j;
int ArrayLength;

if (srcCharArrayLength > 0)	// CR[͊܂܂Ȃ
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (srcCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}

if (ArrayLength < 1) return -1;

for(i=iStart;i<Length;i++)
	{
	for(j=0;j<ArrayLength;j++)
		{
		if (CompareChar(StringData[i], srcCharArray[j], bIgnoreCase) == 0)
			return i;
		}
	}

return -1;
}

int CString::FindOneOf(CString& srcString, int iStart, int bIgnoreCase)
{
return FindOneOf(srcString.StringData, srcString.Length, iStart, bIgnoreCase);
}

void CString::Format(const char *srcFormatString, ...)
{
va_list VarList;

va_start(VarList, srcFormatString);
Format(srcFormatString, VarList);
va_end(VarList);
}

void CString::Format(const char *srcFormatString, va_list srcVarList)
{
if (BufferLength > 0) Empty();
InsertFormat(0, srcFormatString, srcVarList);
}

void CString::InsertFormat(int InsertPos, const char *srcFormatString, ...)
{
va_list VarList;

va_start(VarList, srcFormatString);
InsertFormat(InsertPos, srcFormatString, VarList);
va_end(VarList);
}

void CString::InsertFormat(int InsertPos, const char *srcFormatString, va_list srcVarList)
{
int StringBufferLength;
char dummybuf[1];
char *StringBuffer;

StringBufferLength=vsnprintf(dummybuf, 1, srcFormatString, srcVarList);
if (StringBufferLength < 0)
	{
	// *** if glibc 2.0 or earlier, returns minus value when short buffer.
	StringBufferLength=CString_MallocEach;
	while (-1)
		{
		// allocate buffer
		StringBuffer=(char *)malloc((StringBufferLength+1)*sizeof(char));
		if (StringBuffer == NULL) return;	// ignore

		if (vsnprintf(StringBuffer, StringBufferLength, srcFormatString, srcVarList) >= 0)
			break;
		free(StringBuffer);
		StringBufferLength+=CString_MallocEach;
		}

	Insert(InsertPos, StringBuffer, StringBufferLength, 1);
	free(StringBuffer);
	return;
	}

// allocate buffer
StringBuffer=(char *)malloc((StringBufferLength+1)*sizeof(char));
if (StringBuffer == NULL) return;	// ignore

vsprintf(StringBuffer, srcFormatString, srcVarList);
Insert(InsertPos, StringBuffer, StringBufferLength, 1);
free(StringBuffer);
}

int CString::Compare(CString& destString, int bIgnoreCase)
{
int i;

if (Length < destString.Length) return -1;
else if (Length > destString.Length) return 1;

for(i=0;i<Length;i++)
	{
	if (CompareChar(StringData[i], destString.StringData[i], bIgnoreCase) != 0)
		return (StringData[i]-destString.StringData[i]);
	}
return 0;
}

int CString::Compare(const char destChar, int bIgnoreCase)
{
if (Length < 1) return -1;
else if (Length > 1) return 1;

if (StringData[0] != CString::CharToCChar(destChar))
	return (StringData[0]-CString::CharToCChar(destChar));
return 0;
}

int CString::Compare(const char *destCharArray, int srcCharArrayLength, int bIgnoreCase)
{
int ArrayLength;
CChar *destCharArrayConverted;
int ret;

ArrayLength=CString::CharArrayToCCharArray(destCharArray, srcCharArrayLength,
	&destCharArrayConverted);
if (ArrayLength < 0) return 0;

ret=Compare(destCharArrayConverted, ArrayLength, bIgnoreCase);

free(destCharArrayConverted);
return ret;
}

int CString::Compare(const CChar destChar, int bIgnoreCase)
{
if (Length < 1) return -1;
else if (Length > 1) return 1;

if (StringData[0] != destChar)
	return (StringData[0]-destChar);
return 0;
}

int CString::Compare(const CChar *destCharArray, int srcCharArrayLength, int bIgnoreCase)
{
int i;
int ArrayLength;

if (srcCharArrayLength > 0)	// CR[͊܂܂Ȃ
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (destCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}

if (Length < ArrayLength) return -1;
else if (Length > ArrayLength) return 1;

for(i=0;i<Length;i++)
	{
	if (CompareChar(StringData[i], destCharArray[i], bIgnoreCase) != 0)
		return (StringData[i]-destCharArray[i]);
	}
return 0;
}

CChar CString::GetAt(int iIndex)
{
if ((iIndex < 0)||(iIndex >= Length)) return (CChar)-1;

return StringData[iIndex];
}

void CString::SetAt(int iIndex, CChar srcChar)
{
if ((iIndex < 0)||(iIndex >= Length)) return;

StringData[iIndex]=srcChar;

// StringDataCharArray must be freed before SetAt
if (StringDataCharArray != NULL)
	{
	free(StringDataCharArray);
	StringDataCharArray=NULL;
	}

// clear chararray
if (StringDataCharArray != NULL)
	{
	free(StringDataCharArray);
	StringDataCharArray=NULL;
	}

return;
}

int CString::IsEmpty()
{
if (Length < 1) return 1;
else return 0;
}

CString CString::Left(int iCount)
{
CString SubString;

if (iCount < 1) return SubString;	// null string
SubString.Insert(0, StringData, min(iCount, Length), 1);
return SubString;
}

CString CString::Mid(int iStart, int iLength)
{
CString SubString;

if (iLength == 0) return SubString;	// null string
else if (iLength < 0)
	{
	if (iStart >= 0)
		SubString.Insert(0, &(StringData[min(iStart, Length)]), Length-min(iStart, Length), 1);
	else	SubString.Insert(0, StringData, Length, 1);
	}
else	{
	if (iStart >= 0)
		SubString.Insert(0, &(StringData[min(iStart, Length)]), min(iLength, Length-min(iStart, Length)), 1);
	else	SubString.Insert(0, StringData, min(Length, iLength), 1);
	}

return SubString;
}

CString CString::Right(int iCount)
{
CString SubString;

if (iCount < 1) return SubString;	// null string
SubString.Insert(0, &(StringData[Length-min(iCount, Length)]), min(iCount, Length), 1);
return SubString;
}

CString CString::Lower()
{
CChar *DestCharArray;
int DestCharArrayLength;
CString DestString;

DestCharArrayLength=CString::CCharArrayLower(StringData, Length,
	&DestCharArray);
if (DestCharArrayLength < 0) return DestString;

DestString.Insert(0, DestCharArray, DestCharArrayLength, 1);
free(DestCharArray);

return DestString;
}

CString CString::Upper()
{
CChar *DestCharArray;
int DestCharArrayLength;
CString DestString;

DestCharArrayLength=CString::CCharArrayUpper(StringData, Length,
	&DestCharArray);
if (DestCharArrayLength < 0) return DestString;

DestString.Insert(0, DestCharArray, DestCharArrayLength, 1);
free(DestCharArray);

return DestString;
}

CString CString::Reverse()
{
CString DestString;
int i;

for(i=Length-1;i>=0;i--)
	DestString.Insert(DestString.Length, StringData[i], 1);
return DestString;
}

CString CString::Remove(char srcChar, int bIgnoreCase)
{
return Remove(CString::CharToCChar(srcChar), bIgnoreCase);
}

CString CString::Remove(CChar srcChar, int bIgnoreCase)
{
CString DestString;
int i;

for(i=0;i<Length;i++)
	{
	if (CompareChar(StringData[i], srcChar, bIgnoreCase) == 0)
		DestString.Insert(DestString.Length, StringData[i], 1);
	}

return DestString;
}

CString CString::Remove(char *srcCharArray, int srcCharArrayLength, int bIgnoreCase)
{
int ArrayLength;
CChar *srcCharArrayConverted;
CString DestString, DestString2;

ArrayLength=CString::CharArrayToCCharArray(srcCharArray, srcCharArrayLength,
	&srcCharArrayConverted);
if (ArrayLength < 1) return DestString;

DestString=(CString)Remove(srcCharArrayConverted, ArrayLength, bIgnoreCase);

free(srcCharArrayConverted);
return DestString;
}

CString CString::Remove(CChar *srcCharArray, int srcCharArrayLength, int bIgnoreCase)
{
CString DestString;
int i, j, ArrayLength;

if (srcCharArrayLength >= 0)
	ArrayLength=srcCharArrayLength;
else	{
	for(i=0;;i++)
		{
		if (srcCharArray[i] == 0)
			{
			ArrayLength=i;
			break;
			}
		}
	}

for(i=0;i<=Length-ArrayLength;i++)
	{
	if (CompareChar(StringData[i], srcCharArray[0], bIgnoreCase) == 0)
		{
		int Found;

		Found=1;
		for(j=1;j<ArrayLength;j++)
			{
			if (CompareChar(StringData[i+j], srcCharArray[j], bIgnoreCase) == 0)
				{
				Found=0;
				break;
				}
			}

		if (Found == 0)
			DestString.Insert(DestString.Length, StringData[i], 1);
		else	i+=(ArrayLength-1);
		}
	else	DestString.Insert(DestString.Length, StringData[i], 1);
	}

return DestString;
}

CString CString::Remove(CString& srcString, int bIgnoreCase)
{
return Remove(srcString.StringData, srcString.Length, bIgnoreCase);
}

CString CString::Replace(char *oldString, int oldStringLength, char *newString, int newStringLength)
{
CString DestString;
int i, j, ArrayLength1, ArrayLength2;

if (oldStringLength >= 0)
	ArrayLength1=oldStringLength;
else	{
	for(i=0;;i++)
		{
		if (oldString[i] == 0)
			{
			ArrayLength1=i;
			break;
			}
		}
	}

if (newStringLength >= 0)
	ArrayLength2=newStringLength;
else	{
	for(i=0;;i++)
		{
		if (newString[i] == 0)
			{
			ArrayLength2=i;
			break;
			}
		}
	}

for(i=0;i<Length;i++)
	{
	if (StringData[i] == oldString[0])
		{
		int Found;

		Found=1;
		for(j=1;j<min(ArrayLength1, Length-i);j++)
			{
			if (StringData[i+j] != oldString[j])
				{
				Found=0;
				break;
				}
			}

		if (Found == 0)
			DestString.Insert(DestString.Length, StringData[i], 1);
		else	{
			DestString.Insert(DestString.Length, newString, ArrayLength2, 1);
			i+=(ArrayLength1-1);
			}
		}
	else	DestString.Insert(DestString.Length, StringData[i], 1);
	}

return DestString;
}

CString CString::Replace(CChar *oldString, int oldStringLength, CChar *newString, int newStringLength)
{
CString DestString;
int i, j, ArrayLength1, ArrayLength2;

if (oldStringLength >= 0)
	ArrayLength1=oldStringLength;
else	{
	for(i=0;;i++)
		{
		if (oldString[i] == 0)
			{
			ArrayLength1=i;
			break;
			}
		}
	}

if (newStringLength >= 0)
	ArrayLength2=newStringLength;
else	{
	for(i=0;;i++)
		{
		if (newString[i] == 0)
			{
			ArrayLength2=i;
			break;
			}
		}
	}

for(i=0;i<Length;i++)
	{
	if (StringData[i] == oldString[0])
		{
		int Found;

		Found=1;
		for(j=1;j<min(ArrayLength1, Length-i);j++)
			{
			if (StringData[i+j] != oldString[j])
				{
				Found=0;
				break;
				}
			}

		if (Found == 0)
			DestString.Insert(DestString.Length, StringData[i], 1);
		else	{
			DestString.Insert(DestString.Length, newString, ArrayLength2, 1);
			i+=(ArrayLength1-1);
			}
		}
	else	DestString.Insert(DestString.Length, StringData[i], 1);
	}

return DestString;
}

CString CString::Replace(CString& oldString, CString& newString)
{
return Replace(oldString.StringData, oldString.Length, newString.StringData, newString.Length);
}

CString CString::Replace(char *oldString, char *newString)
{
return Replace(oldString, -1, newString, -1);
}

CString CString::Replace(CChar *oldString, CChar *newString)
{
return Replace(oldString, -1, newString, -1);
}

CString CString::TrimLeft(char srcChar)
{
return TrimLeft(CString::CharToCChar(srcChar));
}

CString CString::TrimLeft(CChar srcChar)
{
int i;

i=0;
while ((i < Length)&&(StringData[i] == srcChar)) i++;
return Mid(i);
}

CString CString::TrimRight(char srcChar)
{
return TrimRight(CString::CharToCChar(srcChar));
}

CString CString::TrimRight(CChar srcChar)
{
int i;

i=Length-1;
while ((i >= 0)&&(StringData[i] == srcChar)) i--;
return Mid(0, i);
}

CString CString::Trim(char srcChar)
{
return Trim(CString::CharToCChar(srcChar));
}

CString CString::EncodeIllegalHtmlChar()
{
CString ResultString;
int i;

ResultString.Empty();
for(i=0;i<Length;i++)
	{
	switch (StringData[i])
		{
		case '<':
			ResultString+="&lt;";
			break;
		case '>':
			ResultString+="&gt;";
			break;
		case '&':
			ResultString+="&amp;";
			break;
		case '\"':
			ResultString+="&quot;";
			break;
		default:
			ResultString+=StringData[i];
		}
	}
return ResultString;
}

CString CString::DecodeIllegalHtmlChar()
{
CString ResultString;
int i;

ResultString.Empty();
for(i=0;i<Length;i++)
	{
	if ((StringData[i] == '&')&&(Find(';', i+1, 1, 1) >= 0))
		{
		CString Sub;

		Sub=Mid(i+1, Find(';', i+1, 1, 1)-(i+1));
		if (Sub == (char *)"lt")
			ResultString+='<';
		else if (Sub == (char *)"gt")
			ResultString+='>';
		else if (Sub == (char *)"amp")
			ResultString+='&';
		else if (Sub == (char *)"quot")
			ResultString+='\"';
		i+=Sub.Length+1;
		}
	else	ResultString+=StringData[i];
	}
return ResultString;
}

CString CString::EncodeURI()
{
CString ResultString;
int i;

ResultString.Empty();
for(i=0;i<Length;i++)
	{
	if ((char unsigned)(StringData[i]) >= 0x80)
		{
		CString Str;

		Str.Format("%%%02X", (char unsigned)(StringData[i]));
		ResultString+=Str;
		}
	else	{
		switch (StringData[i])
			{
			case ' ':
				ResultString+="+";
				break;
			case '\"':
				ResultString+="%22";
				break;
			case '#':
				ResultString+="%23";
				break;
			case '$':
				ResultString+="%24";
				break;
			case '%':
				ResultString+="%25";
				break;
			case '&':
				ResultString+="%26";
				break;
			case '+':
				ResultString+="%2B";
				break;
			case ',':
				ResultString+="%2C";
				break;
			case '/':
				ResultString+="%2F";
				break;
			case ':':
				ResultString+="%3A";
				break;
			case ';':
				ResultString+="%3B";
				break;
			case '<':
				ResultString+="%3C";
				break;
			case '=':
				ResultString+="%3D";
				break;
			case '>':
				ResultString+="%3E";
				break;
			case '?':
				ResultString+="%3F";
				break;
			case '@':
				ResultString+="%40";
				break;
			case '[':
				ResultString+="%5B";
				break;
			case '\\':
				ResultString+="%5C";
				break;
			case ']':
				ResultString+="%5D";
				break;
			case '^':
				ResultString+="%5E";
				break;
			case '`':
				ResultString+="%60";
				break;
			case '{':
				ResultString+="%7B";
				break;
			case '|':
				ResultString+="%7C";
				break;
			case '}':
				ResultString+="%7D";
				break;
			default:
				ResultString+=StringData[i];
			}
		}
	}
return ResultString;
}

CString CString::DecodeURI()
{
CString ResultString;
int i;
char HEXstr[] = "0123456789ABCDEF";
char ch;

ResultString.Empty();
for(i=0;i<Length;i++)
	{
	if ((StringData[i] == '%')&&(i+2 < Length))
		{
		if (strchr(HEXstr, toupper(StringData[i+1])) != NULL)
			ch=((char)(strchr(HEXstr, toupper(StringData[i+1]))-HEXstr) << 4);
		else	ch=0;

		if (strchr(HEXstr, toupper(StringData[i+2])) != NULL)
			ch|=(char)(strchr(HEXstr, toupper(StringData[i+2]))-HEXstr);
		else	ch|=0;
		i+=2;

		ResultString+=ch;
		}
	else if (StringData[i] == '+')
		ResultString+=' ';
	else	ResultString+=StringData[i];
	}
return ResultString;
}

CString CString::Trim(CChar srcChar)
{
int i, j;

if (Length < 1) return "";

i=0;
while ((i < Length)&&(StringData[i] == srcChar)) i++;
j=Length-1;
while ((j >= i-1)&&(StringData[j] == srcChar)) j--;
return Mid(i, j-i+1);
}

// operators
CString& CString::operator=(const CString& srcString)
{
if (Length > 0) Empty();
Insert(0, srcString, 1);

return (*this);
}

// operators
CString& CString::operator=(const char srcChar)
{
if (Length > 0) Empty();
Insert(0, srcChar, 1);

return (*this);
}

// operators
CString& CString::operator=(const char *srcString)
{
if (Length > 0) Empty();
Insert(0, (char *)srcString, -1, 1);

return (*this);
}

// operators
CString& CString::operator=(const CChar srcChar)
{
if (Length > 0) Empty();
Insert(0, srcChar, 1);

return (*this);
}

// operators
CString& CString::operator=(const CChar *srcString)
{
if (Length > 0) Empty();
Insert(0, (CChar *)srcString, -1, 1);

return (*this);
}

// operators
CString& CString::operator+=(const CString& srcString)
{
Insert(Length, srcString, 1);

return (*this);
}

// operators
CString& CString::operator+=(const char srcChar)
{
Insert(Length, srcChar, 1);

return (*this);
}

// operators
CString& CString::operator+=(const char *srcString)
{
Insert(Length, (char *)srcString, -1, 1);

return (*this);
}

// operators
CString& CString::operator+=(const CChar srcChar)
{
Insert(Length, srcChar, 1);

return (*this);
}

// operators
CString& CString::operator+=(const CChar *srcString)
{
Insert(Length, (CChar *)srcString, -1, 1);

return (*this);
}

// operators
CString operator+(const CString& srcString1, const CString& srcString2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, srcString1, 1);
DestString.Insert(DestString.Length, srcString2, 1);

return (DestString);
}

// operators
CString operator+(const CString& srcString1, const char srcChar2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, srcString1, 1);
DestString.Insert(DestString.Length, (char)srcChar2, 1);

return DestString;
}

// operators
CString operator+(const CString& srcString1, const char *srcString2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, srcString1, 1);
DestString.Insert(DestString.Length, (char *)srcString2, -1, 1);

return DestString;
}

// operators
CString operator+(const CString& srcString1, const CChar srcChar2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, srcString1, 1);
DestString.Insert(DestString.Length, (CChar)srcChar2, 1);

return DestString;
}

// operators
CString operator+(const CString& srcString1, const CChar *srcString2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, srcString1, 1);
DestString.Insert(DestString.Length, (CChar *)srcString2, -1, 1);

return DestString;
}

// operators
CString operator+(const char srcChar1, const CString& srcString2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, (char)srcChar1, 1);
DestString.Insert(DestString.Length, srcString2, 1);

return DestString;
}

// operators
CString operator+(const char *srcString1, const CString& srcString2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, (char *)srcString1, -1, 1);
DestString.Insert(DestString.Length, srcString2, 1);

return DestString;
}

// operators
CString operator+(const CChar srcChar1, const CString& srcString2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, (CChar)srcChar1, 1);
DestString.Insert(DestString.Length, srcString2, 1);

return DestString;
}

// operators
CString operator+(const CChar *srcString1, const CString& srcString2)
{
CString DestString;

DestString.Empty();
DestString.Insert(0, (CChar *)srcString1, -1, 1);
DestString.Insert(DestString.Length, srcString2, 1);

return DestString;
}

// operators
int operator==(CString srcString1, CString srcString2)
{
return (srcString1.Compare(srcString2, 0) == 0);
}

// operators
int operator==(CString srcString1, const char srcChar2)
{
return (srcString1.Compare(srcChar2, 0) == 0);
}

// operators
int operator==(CString srcString1, const char *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) == 0);
}

// operators
int operator==(CString srcString1, const CChar srcChar2)
{
return (srcString1.Compare(srcChar2, 0) == 0);
}

// operators
int operator==(CString srcString1, const CChar *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) == 0);
}

// operators
int operator==(const char srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) == 0);
}

// operators
int operator==(const char *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) == 0);
}

// operators
int operator==(const CChar srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) == 0);
}

// operators
int operator==(const CChar *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) == 0);
}

// operators
int operator!=(CString srcString1, CString srcString2)
{
return (srcString1.Compare(srcString2, 0) != 0);
}

// operators
int operator!=(CString srcString1, const char srcChar2)
{
return (srcString1.Compare(srcChar2, 0) != 0);
}

// operators
int operator!=(CString srcString1, const char *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) != 0);
}

// operators
int operator!=(CString srcString1, const CChar srcChar2)
{
return (srcString1.Compare(srcChar2, 0) != 0);
}

// operators
int operator!=(CString srcString1, const CChar *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) != 0);
}

// operators
int operator!=(const char srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) != 0);
}

// operators
int operator!=(const char *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) != 0);
}

// operators
int operator!=(const CChar srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) != 0);
}

// operators
int operator!=(const CChar *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) != 0);
}

// operators
int operator>=(CString srcString1, CString srcString2)
{
return (srcString1.Compare(srcString2, 0) >= 0);
}

// operators
int operator>=(CString srcString1, const char srcChar2)
{
return (srcString1.Compare(srcChar2, 0) >= 0);
}

// operators
int operator>=(CString srcString1, const char *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) >= 0);
}

// operators
int operator>=(CString srcString1, const CChar srcChar2)
{
return (srcString1.Compare(srcChar2, 0) >= 0);
}

// operators
int operator>=(CString srcString1, const CChar *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) >= 0);
}

// operators
int operator>=(const char srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) <= 0);
}

// operators
int operator>=(const char *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) <= 0);
}

// operators
int operator>=(const CChar srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) <= 0);
}

// operators
int operator>=(const CChar *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) <= 0);
}

// operators
int operator<=(CString srcString1, CString srcString2)
{
return (srcString1.Compare(srcString2, 0) <= 0);
}

// operators
int operator<=(CString srcString1, const char srcChar2)
{
return (srcString1.Compare(srcChar2, 0) <= 0);
}

// operators
int operator<=(CString srcString1, const char *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) <= 0);
}

// operators
int operator<=(CString srcString1, const CChar srcChar2)
{
return (srcString1.Compare(srcChar2, 0) <= 0);
}

// operators
int operator<=(CString srcString1, const CChar *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) <= 0);
}

// operators
int operator<=(const char srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) >= 0);
}

// operators
int operator<=(const char *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) >= 0);
}

// operators
int operator<=(const CChar srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) >= 0);
}

// operators
int operator<=(const CChar *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) >= 0);
}

// operators
int operator>(CString srcString1, CString srcString2)
{
return (srcString1.Compare(srcString2, 0) > 0);
}

// operators
int operator>(CString srcString1, const char srcChar2)
{
return (srcString1.Compare(srcChar2, 0) > 0);
}

// operators
int operator>(CString srcString1, const char *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) > 0);
}

// operators
int operator>(CString srcString1, const CChar srcChar2)
{
return (srcString1.Compare(srcChar2, 0) > 0);
}

// operators
int operator>(CString srcString1, const CChar *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) > 0);
}

// operators
int operator>(const char srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) < 0);
}

// operators
int operator>(const char *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) < 0);
}

// operators
int operator>(const CChar srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) < 0);
}

// operators
int operator>(const CChar *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) < 0);
}

// operators
int operator<(CString srcString1, CString srcString2)
{
return (srcString1.Compare(srcString2, 0) < 0);
}

// operators
int operator<(CString srcString1, const char srcChar2)
{
return (srcString1.Compare(srcChar2, 0) < 0);
}

// operators
int operator<(CString srcString1, const char *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) < 0);
}

// operators
int operator<(CString srcString1, const CChar srcChar2)
{
return (srcString1.Compare(srcChar2, 0) < 0);
}

// operators
int operator<(CString srcString1, const CChar *srcString2)
{
return (srcString1.Compare(srcString2, -1, 0) < 0);
}

// operators
int operator<(const char srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) > 0);
}

// operators
int operator<(const char *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) > 0);
}

// operators
int operator<(const CChar srcChar1, CString srcString2)
{
return (srcString2.Compare(srcChar1, 0) > 0);
}

// operators
int operator<(const CChar *srcString1, CString srcString2)
{
return (srcString2.Compare(srcString1, -1, 0) > 0);
}

// operators
CChar CString::operator[](int iIndex)
{
return GetAt(iIndex);
}

CString::operator const CChar *()
{
return (const CChar *)StringData;
}

CString::operator const char *()
{
int convertedLength;

if (StringDataCharArray == NULL)
	{
	convertedLength=CString::CCharArrayToCharArray(StringData, Length,
		&StringDataCharArray);
	if ((StringDataCharArray == NULL)||(convertedLength < 1))
		return "";
	}

return (const char *)StringDataCharArray;
}

// private methods
void CString::ReallocBuffer(int requestedLength)
{
int newBufferLength;

// StringDataCharArray must be freed before buffer reallocation.
if (StringDataCharArray != NULL)
	{
	free(StringDataCharArray);
	StringDataCharArray=NULL;
	}

if ((BufferLength%CString_MallocEach) != 0)
	BufferLength-=BufferLength%CString_MallocEach;
	// no exception

newBufferLength=(requestedLength/CString_MallocEach)*CString_MallocEach+
	(((requestedLength%CString_MallocEach) > 0)?CString_MallocEach:0);
if (newBufferLength != BufferLength)
	{
	if (newBufferLength > 0)
		{
		if (StringData != NULL)
			StringData=(CChar *)realloc(StringData, newBufferLength*sizeof(CChar));
		else	StringData=(CChar *)malloc(newBufferLength*sizeof(CChar));

		if (StringData == NULL)
			{
			// no exception
			BufferLength=0;
			return;
			}
		}
	else	{
		free(StringData);
		StringData=NULL;
		}

	BufferLength=newBufferLength;
	}
}

// self testing
#ifdef CCLASSDEBUG
void CString::Dump()
{
int i;

printf("Length=%i;BufferLength=%i;", Length, BufferLength);
for(i=0;i<Length;i++) printf("%i,", CString::CCharToChar(StringData[i]));
}

void CString::SelfTest()
{
printf("Self testing CString() class..\n");

{
printf("  step 1: constructors test..\n");

CString Str1;
CString Str2((char)'y', 10);
CString Str3((char *)"yes", -1, 10);
CString Str4(Str2, 2);
int i;

printf("    Null string ... ["); Str1.Dump(); printf("]\n");
printf("    'y'x10 ... ["); Str2.Dump(); printf("]\n");
printf("    \"yes\"x10 ... ["); Str3.Dump(); printf("]\n");
printf("    'y'x20 ... ["); Str4.Dump(); printf("]\n");
}

{
CString Str1("Yes"), Str2("No"), Str3, Str4, Str5;

printf("  step 2: generic methods test..\n");

printf("    started ... ["); Str1.Dump(); printf("]\n");
printf("    \"Yes\" ... ["); Str3.Insert(0, Str1, 1); Str4.Insert(0, Str3, 1); Str5.Insert(0, Str4, 1); Str5.Dump(); printf("]\n");
printf("    insert 'p'x3 to second position ... ["); Str1.Insert(1, (char)'p', 3); Str1.Dump(); printf("]\n");
printf("    delete previously inserted 'p'x3 ... ["); Str1.Delete(1, 3); Str1.Dump(); printf("]\n");
printf("    append \"No\" ... ["); Str1.Insert(Str1.Length, Str2, 1); Str1.Dump(); printf("]\n");
printf("    find 'e' ... %i\n", Str1.Find('e'));
printf("    find \"sN\" ... %i\n", Str1.Find((char *)"sN"));
printf("    find \"Sn\" without case ... %i\n", Str1.Find((char *)"Sn", 2, 0, 1));
printf("    find \"Sn\" with case ... %i\n", Str1.Find((char *)"Sn", 2, 0, 0));
printf("    find one of \"SZ\" without case ... %i\n", Str1.FindOneOf((char *)"SZ", 2, 0, 1));
printf("    find one of \"SZ\" with case ... %i\n", Str1.FindOneOf((char *)"SZ", 2, 0, 0));
printf("    find 'z' ... %i\n", Str1.Find('z'));
printf("    find one of \"abcde\" ... %i\n", Str1.FindOneOf("abcde"));
printf("    format string 1to5 ... "); Str1.Format("%04i:%04i:%04i:%04i:%04i", 1, 2, 3, 4, 5); Str1.Dump(); printf("\n");

Str1.Empty();
Str1.Insert(0, "abcde", 5, 1);
printf("    first 3 bytes of \"abcde\" ... ["); Str1.Left(3).Dump(); printf("]\n");
printf("    first 8 bytes of \"abcde\" ... ["); Str1.Left(8).Dump(); printf("]\n");
printf("    last 3 bytes of \"abcde\" ... ["); Str1.Right(3).Dump(); printf("]\n");
printf("    last 8 bytes of \"abcde\" ... ["); Str1.Right(8).Dump(); printf("]\n");
printf("    3rd-6th bytes of \"abcde\" ... ["); Str1.Mid(2, 3).Dump(); printf("]\n");
printf("    3rd-10th bytes of \"abcde\" ... ["); Str1="abcde"; Str1.Mid(2, 7).Dump(); printf("]\n");

Str1.Empty();
Str1.Insert(0, "StRiNg To UpPeR aNd LoWeR", 25, 1);
printf("    Original string ... ["); Str1.Dump(); printf("]\n");
printf("      To upper ... ["); Str1.Upper().Dump(); printf("]\n");
printf("      To lower ... ["); Str1.Lower().Dump(); printf("]\n");
printf("      Reverse ... ["); Str1.Reverse().Dump(); printf("]\n");
printf("      Remove \"N\" ... ["); Str1.Remove('N').Dump(); printf("]\n");
printf("      Remove \"eR\" ... ["); Str1.Remove("eR").Dump(); printf("]\n");
Str3="eR"; Str4="**REPLACED**";
printf("      Replace \"eR\" to \"**REPLACED**\" ... ["); Str1.Replace(Str3, Str4).Dump(); printf("]\n");
}

{
CString Str, Str2, Str3, Str4, Str5, Str6;

printf("  step 4: operators test..\n");
Str.Insert(0, "abcd");
printf("    Start string ... ["); Str.Dump(); printf("]\n");
printf("    Append \"ef\" ... ["); Str+="ef"; Str.Dump(); printf("]\n");
printf("    Append \"gh\" ... ["); Str2.Empty(); Str2.Insert(0, "gh"); Str+=Str2; Str.Dump(); printf("]\n");
printf("    \"Plus\" + \"Operator\" ... ["); Str2="Plus"; Str3="Operator"; Str4=Str2+Str3; Str4.Dump();
	printf("]\n");
Str2="Hello"; Str3="Hello"; Str4="Hfllo"; Str5="Hdllo";
printf("    \"Hello\" == \"Hello\" ? ... [%i]\n", (Str2 == Str3));
printf("    \"Hello\" == \"Hdllo\" ? ... [%i]\n", (Str2 == Str5));
printf("    \"Hello\" == \"Hfllo\" ? ... [%i]\n", (Str2 == Str4));
printf("    \"Hello\" != \"Hello\" ? ... [%i]\n", (Str2 != Str3));
printf("    \"Hello\" != \"Hdllo\" ? ... [%i]\n", (Str2 != Str5));
printf("    \"Hello\" != \"Hfllo\" ? ... [%i]\n", (Str2 != Str4));
printf("    \"Hello\" >= \"Hello\" ? ... [%i]\n", (Str2 >= Str3));
printf("    \"Hello\" >= \"Hdllo\" ? ... [%i]\n", (Str2 >= Str5));
printf("    \"Hello\" >= \"Hfllo\" ? ... [%i]\n", (Str2 >= Str4));
printf("    \"Hello\" <= \"Hello\" ? ... [%i]\n", (Str2 <= Str3));
printf("    \"Hello\" <= \"Hdllo\" ? ... [%i]\n", (Str2 <= Str5));
printf("    \"Hello\" <= \"Hfllo\" ? ... [%i]\n", (Str2 <= Str4));
printf("    \"Hello\" >  \"Hello\" ? ... [%i]\n", (Str2 > Str3));
printf("    \"Hello\" >  \"Hdllo\" ? ... [%i]\n", (Str2 > Str5));
printf("    \"Hello\" >  \"Hfllo\" ? ... [%i]\n", (Str2 > Str4));
printf("    \"Hello\" <  \"Hello\" ? ... [%i]\n", (Str2 < Str3));
printf("    \"Hello\" <  \"Hdllo\" ? ... [%i]\n", (Str2 < Str5));
printf("    \"Hello\" <  \"Hfllo\" ? ... [%i]\n", (Str2 < Str4));
printf("    operator const char *; Str=%s Str2=%s Str3=%s Str4=%s Str5=%s\n",
	(const char *)Str, (const char *)Str2,
	(const char *)Str3, (const char *)Str4, (const char *)Str5);
Str6.Format("    operator const char *; Str=%s Str2=%s Str3=%s Str4=%s Str5=%s\n",
	(const char *)Str, (const char *)Str2,
	(const char *)Str3, (const char *)Str4, (const char *)Str5);
printf("%s", (const char *)Str6);
}

printf("Self testing CString() completed.\n");
}

#endif
