#include "CQueryString.h"

CQueryString_Item::CQueryString_Item()
{
Name.Empty();
Value.Empty();
}

CQueryString_Item::CQueryString_Item(CQueryString_Item& src)
{
Name=src.Name;
Value=src.Value;
}

CQueryString_Item::~CQueryString_Item()
{
Name.Empty();
Value.Empty();
}

CQueryString_Item& CQueryString_Item::operator=(const CQueryString_Item& src)
{
Name=src.Name;
Value=src.Value;

return (*this);
}

CQueryString::CQueryString()
{
Items.RemoveAll();
}

CQueryString::~CQueryString()
{
Items.RemoveAll();
}

void CQueryString::Open(CString SourceString)
{
CString Sub;
CQueryString_Item Item;
int Pos, Pos2;

Items.RemoveAll();
Pos=0;
do	{
	Pos2=SourceString.Find((char)'&', Pos, 0, 1);
	if (Pos2 < 0) Pos2=SourceString.Length;

	if (Pos2-Pos > 0)
		{
		Sub=SourceString.Mid(Pos, Pos2-Pos);
		if (Sub.Find((char)'=') >= 0)
			{
			Item.Name=Sub.Left(Sub.Find((char)'=')).DecodeURI();
			Item.Value=Sub.Mid(Sub.Find((char)'=')+1).DecodeURI();
			}
		else	{
			// nameless
			Item.Name.Empty();
			Item.Value=Sub.DecodeURI();
			}
		Items.Add(Item);
		}
	Pos=Pos2+1;
	} while (Pos < SourceString.Length);
}

void CQueryString::Close()
{
Items.RemoveAll();
}

int CQueryString::GetItemCount()
{
return Items.Size;
}

int CQueryString::IsExistItem(CString Name)
{
int i;

for(i=0;i<Items.Size;i++)
	{
	if (Items[i].Name == Name) return 1;
	}
return 0;
}

CString CQueryString::GetItemName(int Order)
{
if ((Order < 0)||(Order >= Items.Size))
	throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "CQueryString::GetItemValue"));

return Items[Order].Name;
}

CString CQueryString::GetItemValue(int Order)
{
if ((Order < 0)||(Order >= Items.Size))
	throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "CQueryString::GetItemValue"));

return Items[Order].Value;
}

CString CQueryString::GetItemValue(CString Name)
{
int i;

for(i=0;i<Items.Size;i++)
	{
	if (Items[i].Name == Name) return Items[i].Value;
	}

throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "CQueryString::GetItemValue"));
}
