#ifndef	CMultipartForm_defined
#define	CMultipartForm_defined

#include "CString.h"
#include "CArray.h"

class CMultipartForm_Item_Header
{
public:
	CMultipartForm_Item_Header();
	CMultipartForm_Item_Header(CMultipartForm_Item_Header& src);
	~CMultipartForm_Item_Header();

	CMultipartForm_Item_Header& operator=(const CMultipartForm_Item_Header& src);

	CString Name, Value;
};

class CMultipartForm_Item
{
public:
	CMultipartForm_Item();
	CMultipartForm_Item(CMultipartForm_Item& src);
	~CMultipartForm_Item();

	CMultipartForm_Item& operator=(const CMultipartForm_Item& src);

	int IsExistHeader(CString HeaderName);
	CString GetHeaderValue(CString HeaderName);

	CString ItemName;
	CArray<CMultipartForm_Item_Header, CMultipartForm_Item_Header> Headers;
	int Begin, End;
};

class CMultipartForm
{
public:
	CMultipartForm();
	~CMultipartForm();

	void Open(FILE *hInputFile, int Length);
	void Close();

	int GetFormCount();
	int IsExistFormItem(CString ItemName);
	CString GetItemName(int Order);
	CMultipartForm_Item& GetFormItem(int Order);
	CMultipartForm_Item& GetFormItem(CString ItemName);
	CString GetFormItemValue(int Order);
	CString GetFormItemValue(CString ItemName);

	CString Boundary, EndBoundary;
	FILE *hTmpFile;
private:
	CArray<CMultipartForm_Item, CMultipartForm_Item> FormData;

	static CString ReadFileLine(FILE *hFile, int MaxLength);
};

#endif
