#include "CMultipartForm.h"

CMultipartForm_Item_Header::CMultipartForm_Item_Header()
{
Name="";
Value="";
}

CMultipartForm_Item_Header::CMultipartForm_Item_Header(CMultipartForm_Item_Header& src)
{
Name=src.Name;
Value=src.Value;
}

CMultipartForm_Item_Header::~CMultipartForm_Item_Header()
{
Name="";
Value="";
}

CMultipartForm_Item_Header& CMultipartForm_Item_Header::operator=(const CMultipartForm_Item_Header& src)
{
Name=src.Name;
Value=src.Value;

return (*this);
}

CMultipartForm_Item::CMultipartForm_Item()
{
ItemName="";
Headers.RemoveAll();
Begin=0;
End=0;
}

CMultipartForm_Item::CMultipartForm_Item(CMultipartForm_Item& src)
{
int i;

ItemName=src.ItemName;
Headers.SetSize(src.Headers.Size);
for(i=0;i<Headers.Size;i++) Headers[i]=src.Headers[i];
Begin=src.Begin;
End=src.End;
}

CMultipartForm_Item::~CMultipartForm_Item()
{
ItemName="";
Headers.RemoveAll();
Begin=0;
End=0;
}

CMultipartForm_Item& CMultipartForm_Item::operator=(const CMultipartForm_Item& src)
{
int i;

ItemName=src.ItemName;
Headers.SetSize(src.Headers.Size);
for(i=0;i<Headers.Size;i++) Headers[i]=((CMultipartForm_Item&)src).Headers[i];
Begin=src.Begin;
End=src.End;

return (*this);
}

int CMultipartForm_Item::IsExistHeader(CString HeaderName)
{
int i;

for(i=0;i<Headers.Size;i++)
	{
	if (Headers[i].Name == HeaderName) return 1;
	}
return 0;
}

CString CMultipartForm_Item::GetHeaderValue(CString HeaderName)
{
int i;

for(i=0;i<Headers.Size;i++)
	{
	if (Headers[i].Name == HeaderName) return Headers[i].Value;
	}

throw(CException(CException::CErrorTypeErrorCode,
	CException::CIllegalParameter, "CMultipartForm_Item::GetHeaderValue"));
}

CMultipartForm::CMultipartForm()
{
Boundary="";
FormData.RemoveAll();
hTmpFile=NULL;
}

CMultipartForm::~CMultipartForm()
{
Close();
}

void CMultipartForm::Open(FILE *hInputFile, int Length)
{
CString Buffer, Buffer2;
int LeftSize;

// ꎞt@C쐬
hTmpFile=tmpfile();
if (hTmpFile == NULL)
	throw(CException(CException::CErrorTypeException,
		errno, "CMultipartForm::Open"));

// coCgJEg
LeftSize=Length;

// ŏ1s͋؂
Boundary=ReadFileLine(hInputFile, min(4096, LeftSize));
LeftSize-=Boundary.Length;
if (Boundary.Find(13) >= 0) Boundary=Boundary.Left(Boundary.Find(13));
if (Boundary.Find(10) >= 0) Boundary=Boundary.Left(Boundary.Find(10));

// I̋؂
EndBoundary=Boundary + "--";

while ((feof(hInputFile) == 0)&&(LeftSize > 0))	// t@CGhȂΏI
	{
	CMultipartForm_Item Item;
	CMultipartForm_Item_Header Header;
	int i;

	// wb_ǂݏo
	while ((feof(hInputFile) == 0)&&(LeftSize > 0))	// t@CGhȂΏI
		{
		Buffer=ReadFileLine(hInputFile, min(4096, LeftSize));
		LeftSize-=Buffer.Length;
		fwrite((void *)(const char *)Buffer, Buffer.Length, 1, hTmpFile);
		Buffer2=Buffer;
		if (Buffer2.Find(13) >= 0) Buffer2=Buffer2.Left(Buffer2.Find(13));
		if (Buffer2.Find(10) >= 0) Buffer2=Buffer2.Left(Buffer2.Find(10));
		if (Buffer2.Length < 1) break;	// 󂫍s΃wb_I

		if (Buffer2.Find(':') >= 0)
			{
			Header.Name=Buffer2.Left(Buffer2.Find(':'));
			Header.Value=Buffer2.Mid(Buffer2.Find(':')+1).Trim();
			Item.Headers.Add(Header);
			}
		}

	// "Content-Disposition" wb_ name="" Ƃ
	// ACêŎ擾Ă
	for(i=0;i<Item.Headers.Size;i++)
		{
		if (Item.Headers[i].Name == (char *)"Content-Disposition")
			{
			if (Item.Headers[i].Value.Find("name=") >= 0)
				{
				int Pos1, Pos2;

				Pos1=Item.Headers[i].Value.Find("name=")+5;
				Pos2=Item.Headers[i].Value.Find(';', Pos1);
				if (Pos2 >= 0)
					Item.ItemName=Item.Headers[i].Value.Mid(Pos1, Pos2-Pos1);
				else	Item.ItemName=Item.Headers[i].Value.Mid(Pos1);
				if ((Item.ItemName[0] == '\"')
					&&(Item.ItemName[Item.ItemName.Length-1] == '\"'))
					Item.ItemName=Item.ItemName.Mid(1, Item.ItemName.Length-2);
				}
			}
		}

	// ꎞt@Cł̃f[^̃X^[gn_L^
	Item.Begin=ftell(hTmpFile);
	// ꎞt@Cł̃f[^̃Ghn_ꎞIɋLĂ
	Item.End=Item.Begin;

	// f[^ǂݏo
	while ((feof(hInputFile) == 0)&&(LeftSize > 0))	// t@CGhȂΏI
		{
		Buffer=ReadFileLine(hInputFile, min(4096, LeftSize));
		LeftSize-=Buffer.Length;
		fwrite((void *)(const char *)Buffer, Buffer.Length, 1, hTmpFile);
		Buffer2=Buffer;
		if (Buffer2.Find(13) >= 0) Buffer2=Buffer2.Left(Buffer2.Find(13));
		if (Buffer2.Find(10) >= 0) Buffer2=Buffer2.Left(Buffer2.Find(10));
		if ((Buffer2 == Boundary)||(Buffer2 == EndBoundary))
			break; // EɈv甲

		// ꎞt@Cł̃f[^̃Ghn_ꎞIɋLĂ
		Item.End=ftell(hTmpFile);
		if (Buffer.Length > 0)
			{
			if ((Buffer[Buffer.Length-1] == 13)||(Buffer[Buffer.Length-1] == 10))
				{
				// sCR,LF,CR+LFȂ΍폜
				Item.End--;
				if (Buffer.Length > 1)
					{
					if ((Buffer[Buffer.Length-1] == 10)&&(Buffer[Buffer.Length-2] == 13))
						Item.End--;
					}
				}
			}
		}

	// tH[f[^ɒǉ
	FormData.Add(Item);
	}

// ꎞt@C̃|C^ɖ߂
rewind(hTmpFile);
}

void CMultipartForm::Close()
{
FormData.RemoveAll();
if (hTmpFile != NULL)
	{
	fclose(hTmpFile);
	hTmpFile=NULL;
	}
}

int CMultipartForm::GetFormCount()
{
return FormData.Size;
}

int CMultipartForm::IsExistFormItem(CString ItemName)
{
int i;

for(i=0;i<FormData.Size;i++)
	{
	if (FormData[i].ItemName == ItemName) return 1;
	}

return 0;
}

CString CMultipartForm::GetItemName(int Order)
{
if ((Order < 0)||(Order >= FormData.Size))
	throw(CException(CException::CErrorTypeException,
		CException::CIllegalParameter, "CMultipartForm::GetFormName"));

return FormData[Order].ItemName;
}

CMultipartForm_Item& CMultipartForm::GetFormItem(int Order)
{
if ((Order < 0)||(Order >= FormData.Size))
	throw(CException(CException::CErrorTypeException,
		CException::CIllegalParameter, "CMultipartForm::GetFormItem"));

return FormData[Order];
}

CMultipartForm_Item& CMultipartForm::GetFormItem(CString ItemName)
{
int i;

for(i=0;i<FormData.Size;i++)
	{
	if (FormData[i].ItemName == ItemName) return FormData[i];
	}

throw(CException(CException::CErrorTypeException,
	CException::CIllegalParameter, "CMultipartForm::GetFormItem"));
}

CString CMultipartForm::GetFormItemValue(int Order)
{
CString Value;
int LeftSize;
FILE *hTmp;
int unsigned ReadSize;
#define	BUFFERSIZE	2048
char buffer[BUFFERSIZE];

if ((Order < 0)||(Order >= FormData.Size))
	throw(CException(CException::CErrorTypeException,
		CException::CIllegalParameter, "CMultipartForm::GetFormItemValue"));

hTmp=hTmpFile;
CMultipartForm_Item& Item=GetFormItem(Order);
fseek(hTmp, Item.Begin, SEEK_SET);

Value.Empty();
LeftSize=Item.End-Item.Begin;
while (LeftSize > 0)
	{
	ReadSize=fread((void *)buffer, 1, min(LeftSize, BUFFERSIZE), hTmp);
	Value.Insert(Value.Length, (char *)buffer, ReadSize);
	LeftSize-=ReadSize;
	}

return Value;
}

CString CMultipartForm::GetFormItemValue(CString ItemName)
{
int i;

for(i=0;i<FormData.Size;i++)
	{
	if (FormData[i].ItemName == ItemName) return GetFormItemValue(i);
	}

throw(CException(CException::CErrorTypeException,
	CException::CIllegalParameter, "CMultipartForm::GetFormItemValue"));
}

CString CMultipartForm::ReadFileLine(FILE *hFile, int MaxLength)
{
CString Line;
int ch;

Line="";
while ((ch=fgetc(hFile)) != EOF)
	{
	if ((ch == 13)||(ch == 10))
		{
		// CR+LF̉sR[hȂ̂
		Line+=(char unsigned)ch;	// sR[h
		if (ch == 13)
			{
			ch=fgetc(hFile);
			if (ch != 10) ungetc(ch, hFile); // LFł͂Ȃ̂Ŗ߂
			else 	Line+=(char unsigned)ch; // sR[h
			}
		break;
		}

	Line+=(char unsigned)ch;
	if (Line.Length >= MaxLength) break;
	}

return Line;
}
