#ifndef	CMd5_defined
#define	CMd5_defined

#include "CString.h"

class CMd5
{
public:
	// constructors
	CMd5();			// create new MD5 class
	CMd5(unsigned char *Data, unsigned long int DataLength);	// create new MD5 class with data

	// methods
	void Init();			// initialize MD5 class
	void Update(unsigned char *Data, unsigned long int DataLength);	// update MD5 class with data
	void Update(char *Data, unsigned long int DataLength);
	void Finish();			// finish MD5 class update.

	// operators
	operator CString();
	CString ToMimeString();

	// destructors
	~CMd5();

	// self testing
	#ifdef CCLASSDEBUG
	static void SelfTest();
	#endif

private:
	// private methods
	void MD5_memcpy(unsigned char *output, unsigned char *input, unsigned int len);
	void MD5Transform(unsigned long int state[4], unsigned char block[64]);
	void Decode(unsigned long int *output, unsigned char *input, unsigned int len);
	void MD5_memset(char unsigned *output, int value, unsigned int len);
	void Encode(unsigned char *output, unsigned long int *input, unsigned int len);

	// MD5 context.
	typedef struct {
		unsigned long int state[4];	// state (ABCD)
		unsigned long int count[2];	// number of bits, modulo 2^64 (lsb first)
		unsigned char buffer[64];	// input buffer
	} MD5_CTX;

	char Finished;			// finished flag
	unsigned char DigestValue[16];	// finished digest value
	MD5_CTX context;		// MD5 context
};

#endif
