#ifndef	CFile_defined
#define	CFile_defined

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include "CString.h"
#include "CArray.h"
#include "CTime.h"
#include "CFifoBuffer.h"

class CFile;

class CFile
{
public:
	// constructor
	CFile();
	CFile(CString FileName, int OpenFlags, mode_t Permissions);
	CFile(int srcFileDescriptor);
	CFile(CFile& srcFile);
	// destructor
	~CFile();

	// static methods
	static mode_t SetFileCreateMask(mode_t newCreateMask);
	static void Delete(CString FileName);
	static void GetStatus(CString FileName, struct stat *destBuffer);
	static void SetPermission(CString FileName, mode_t newPermissions);
	static void SetOwnerUid(CString FileName, uid_t srcOwnerUid);
	static void SetOwnerGid(CString FileName, gid_t srcOwnerGid);
	static void SyncAll();
	static int Wait(CArray<CFile *, CFile *>& ReadFileArray, CArray<CFile *, CFile *>& WriteFileArray,
		CArray<CFile *, CFile *>& ExceptionFileArray, int WaitSec=0, int WaitMicroSec=0);

	// methods
	void Attach(int srcFileDescriptor);
	int Detach();

	void Open(CString FileName, int OpenFlags, mode_t Permissons);
	void Close();

	int ReadByte();
	int WriteByte(char unsigned Data);
	int Read(void *Buffer, size_t BufferSize);
	int Write(void *Buffer, size_t BufferSize);

	void Sync();

	off_t Seek(int Whence=CFile::WhenceEnum_FromFileStart, off_t Position=0);
	void Rewind();

	CFile& Duplicate();
	CFile& Copy();
	int GetCloseOnExecFlag();
	void SetCloseOnExecFlag(int CloseOnExecFlag);
	int GetOpenFlags();
	void SetOpenFlags(int OpenFlags);
	int GetLock(int LockFlag=CFile::LockTypes_SharedLock, int Whence=CFile::WhenceEnum_FromFileStart,
		off_t StartPos=0, off_t Length=0,
		int *lockedWhence=NULL, off_t *lockedStartPos=NULL, off_t *lockedLength=NULL, int *lockedPid=NULL);
	void SetLock(int LockFlag=CFile::LockTypes_SharedLock, int Whence=CFile::WhenceEnum_FromFileStart,
		off_t StartPos=0, off_t Length=0, int TimeoutSec=0);
	void GetStatus(struct stat *destBuffer);
	void SetPermission(mode_t newPermissions);
	void SetOwnerUid(uid_t srcOwnerUid);
	void SetOwnerGid(gid_t srcOwnerGid);

	off_t GetFileSize();
	CTime GetLastAccessTime();
	CTime GetLastModifiedTime();
	CTime GetLastChangedTime();
	uid_t GetOwnerUid();
	gid_t GetOwnerGid();
	mode_t GetPermission();
	CString ReadLine(int MaxLength);

	// signal procedure
	static void SetLockAlarmSignalProc(int Signal);

	// operators
	CFile& operator=(const CFile& srcFile);

	// enumeration
	enum	{
		OpenFlags_Create = O_CREAT,
		OpenFlags_Exclude = O_EXCL,
		OpenFlags_NoCtty = O_NOCTTY,
		OpenFlags_Truncate = O_TRUNC,
		OpenFlags_Append = O_APPEND,
		OpenFlags_NoBlock = O_NONBLOCK,
		OpenFlags_Synchronized = O_SYNC,
		} CFile_OpenFlags;

	enum	{
		LockTypes_SharedLock = F_RDLCK,
		LockTypes_ExclusiveLock = F_WRLCK,
		LockTypes_Unlock = F_UNLCK,
		} CFile_LockTypes;

	enum	{
		WhenceEnum_FromFileStart = SEEK_SET,
		WhenceEnum_FromCurrentFilePos = SEEK_CUR,
		WhenceEnum_FromFileEnd = SEEK_END,
		} CFile_LockWhenceEnum;

	// properties
	int FileDescriptor;
	CFifoBuffer FileBuffer;

	// self testing
	#ifdef CCLASSDEBUG
	void Dump();
	static void SelfTest();
	#endif
};

#endif
