#ifndef	CFifoBuffer_defined
#define	CFifoBuffer_defined

#include "CException.h"
#include <string.h>
#include <malloc.h>

class CFifoBuffer
{
public:
	// constructors, destructors
	CFifoBuffer(int srcBufferSize=32, int srcAutoExtend=0, int srcAutoExtendSize=0);
	~CFifoBuffer();

	// generic methods
	void SetBufferSize(int srcnewBufferSize=0);
	void SetAutoExtend(int srcAutoExtend=0, int srcAutoExtendSize=0);
	void Empty();

	// reader methods
	int ReadByte();
	int Read(char unsigned *destByteDataArray, int destByteDataArraySize);
	int Skip(int srcBytes);
	int GetReadableBufferSize();

	// writer methods
	int WriteByte(char unsigned srcByteData);
	int Write(char unsigned *srcByteDataArray, int srcArraySize);
	int GetWritableBufferSize();
	int PushWriteByte(char unsigned srcByteData);
	int PushWrite(char unsigned *srcByteDataArray, int srcArraySize);

	int BufferSize;		// current buffer size (bytes)
	int AutoExtend;		// 0=fixed buffer, 1=auto extend buffer
	int AutoExtendSize;	// auto extend unit size (bytes)

	int ReaderCursorPos;	// current reader cursor position
	int WriterCursorPos;	// current writer cursor position
	char unsigned *Buffer;	// current buffer

	// self testing
	#ifdef CCLASSDEBUG
	void Dump();
	static void SelfTest();
	#endif
};

#endif
