#ifndef	CException_defined
#define	CException_defined

#include "CString.h"
#include <errno.h>
#include <string.h>

#include <regex.h>

class CException
{
public:
	// constructor
	CException();
	CException(int srcErrNumberType, int srcErrNumber, CString srcPosition);
	CException(int srcErrNumberType, int srcErrNumber, void *srcErrorParameter, CString srcPosition);

	// destructor
	~CException();

	// methods
	void SetLastError(int srcErrNumberType, int srcErrNumber, CString srcPosition);
	void SetLastError(int srcErrNumberType, int srcErrNumber, void *srcErrorParameter, CString srcPosition);
	CString GetErrorMessage();
	CString GetErrorPosition();

	// enumeration
	enum	{
		CErrorTypeNull		= 0,
		CErrorTypeErrorCode	= 1,
		CErrorTypeRegExpError	= 2,
		CErrorTypeException	= 3,
		} CErrorTypeEnum;

	enum	{
		CSuccess			= 0,
		CUnknownError			= -1,
		CIllegalCallOrder		= 1,
		CIllegalParameter		= 2,
		CInternalError			= 3,
		CIllegalStatus			= 4,
		CNoMoreMemory			= 5,
		CAborted			= 6,
		} CExceptionEnum;

	// self testing
	#ifdef CCLASSDEBUG
	static void SelfTest();
	#endif

private:
	int		ErrNumberType;
	int		ErrNumber;
	void		*ErrorParameter;
	CString		Position;
};

#endif
