#include "CException.h"

// constructor
CException::CException()
{
ErrNumberType=0;
ErrNumber=0;
ErrorParameter=NULL;
Position="";
}

// constructor
CException::CException(int srcErrNumberType, int srcErrNumber, CString srcPosition)
{
SetLastError(srcErrNumberType, srcErrNumber, srcPosition);
}

// constructor
CException::CException(int srcErrNumberType, int srcErrNumber, void *srcErrorParameter, CString srcPosition)
{
SetLastError(srcErrNumberType, srcErrNumber, srcErrorParameter, srcPosition);
}

// destructor
CException::~CException()
{
ErrNumberType=0;
ErrNumber=0;
ErrorParameter=NULL;
Position="";
}

// methods
void CException::SetLastError(int srcErrNumberType, int srcErrNumber, CString srcPosition)
{
ErrNumberType=srcErrNumberType;
ErrNumber=srcErrNumber;
Position=srcPosition;
}

// methods
void CException::SetLastError(int srcErrNumberType, int srcErrNumber, void *srcErrorParameter, CString srcPosition)
{
ErrNumberType=srcErrNumberType;
ErrNumber=srcErrNumber;
ErrorParameter=srcErrorParameter;
Position=srcPosition;
}

// methods
CString CException::GetErrorMessage()
{
CString ErrorMessage;

switch (ErrNumberType)
	{
	case CException::CErrorTypeNull:
		ErrorMessage="No Error";
		break;
	case CException::CErrorTypeErrorCode:
		ErrorMessage=strerror(ErrNumber);
		break;
	case CException::CErrorTypeRegExpError:
		{
		char errstr[256];
		int ret2;

		if (ErrorParameter != NULL)
			{
			ret2=regerror(ErrNumber, (const regex_t *)ErrorParameter, errstr, 255);
			if ((ret2 >= 0)&&(ret2 < 255)) errstr[ret2]=0;
			else errstr[255]=0;

			ErrorMessage=errstr;
			}
		else	ErrorMessage.Format("RegExpError #%i", ErrNumber);
		}
		break;
	case CException::CErrorTypeException:
		ErrorMessage.Format("Exception #%i", ErrNumber);
		break;
	}

return ErrorMessage;
}

// methods
CString CException::GetErrorPosition()
{
return Position;
}

// self testing
#ifdef CCLASSDEBUG
void CException::SelfTest()
{
CException Exc;

printf("Self testing CException() class..\n");

printf("  Step1. Error code test..\n");
Exc.SetLastError(CException::CErrorTypeErrorCode, 1, NULL, (CString)"CException::SelfTest");
printf("    Exception=CErrorTypeErrorCode:1 [%s]\n", (const char *)Exc.GetErrorMessage());
Exc.SetLastError(CException::CErrorTypeErrorCode, 2, NULL, (CString)"CException::SelfTest");
printf("    Exception=CErrorTypeErrorCode:2 [%s]\n", (const char *)Exc.GetErrorMessage());
Exc.SetLastError(CException::CErrorTypeErrorCode, 32, NULL, (CString)"CException::SelfTest");
printf("    Exception=CErrorTypeErrorCode:32 [%s]\n", (const char *)Exc.GetErrorMessage());

printf("  Step2. Throw test..\n");
try	{
	throw(CException(CException::CErrorTypeErrorCode, 10, NULL, "CException::SelfTest()"));
	printf("    ** ERROR; NO EXCEPTION RAISED. **\n");
	} catch (CException e)
		{
		printf("    Test exception occured [%s] at [%s]\n",
			(const char *)e.GetErrorMessage(), NULL, (const char *)e.GetErrorPosition());
		}
try	{
	throw(CException(CException::CErrorTypeErrorCode, 20, NULL, "CException::SelfTest()"));
	printf("    ** ERROR; NO EXCEPTION RAISED. **\n");
	} catch (CException e)
		{
		printf("    Test exception occured [%s] at [%s]\n",
			(const char *)e.GetErrorMessage(), NULL, (const char *)e.GetErrorPosition());
		}
try	{
	throw(CException(CException::CErrorTypeErrorCode, 30, NULL, "CException::SelfTest()"));
	printf("    ** ERROR; NO EXCEPTION RAISED. **\n");
	} catch (CException e)
		{
		printf("    Test exception occured [%s] at [%s]\n",
			(const char *)e.GetErrorMessage(), NULL, (const char *)e.GetErrorPosition());
		}

printf("Self testing CException() completed.\n");
}
#endif
