#ifndef	CConfig_defined
#define	CConfig_defined

#include "CString.h"
#include "CArray.h"

class CConfig_Item
{
public:
	CConfig_Item();
	CConfig_Item(const CConfig_Item& srcItem);
	~CConfig_Item();

	void Set(CString srcName, CString srcValue);
	void Set(CConfig_Item& srcItem);
	CConfig_Item& operator=(const CConfig_Item& srcItem);

	CString Name, Value;
};

class CConfig
{
public:
	CConfig();
	CConfig(const CConfig& srcConfig);
	~CConfig();

	CConfig& operator=(const CConfig& srcConfig);

	void Open(CString ConfigFileName);
	void Close();

	int GetItemArraySize();
	CString GetItemName(int Order);
	CString GetItemValue(CString ItemName);
	CString GetItemValue(int Order);
	int IsExistItemName(CString ItemName);

	// self testing
	#ifdef CCLASSDEBUG
	static void SelfTest();
	#endif
private:
	CArray<CConfig_Item, CConfig_Item> ItemArray;

	static CString ReadFileLine(FILE *hFile, int MaxLength);
};

#endif
