#include "CConfig.h"
#include "CException.h"

CConfig_Item::CConfig_Item()
{
Value="";
Name="";
}

CConfig_Item::CConfig_Item(const CConfig_Item& srcItem)
{
Value=srcItem.Value;
Name=srcItem.Name;
}

CConfig_Item::~CConfig_Item()
{
Value="";
Name="";
}

void CConfig_Item::Set(CString srcName, CString srcValue)
{
Value=srcName;
Name=srcValue;
}

void CConfig_Item::Set(CConfig_Item& srcItem)
{
Value=srcItem.Value;
Name=srcItem.Name;
}

CConfig_Item& CConfig_Item::operator=(const CConfig_Item& srcItem)
{
Value=srcItem.Value;
Name=srcItem.Name;

return (*this);
}

CConfig::CConfig()
{
ItemArray.RemoveAll();
}

CConfig::CConfig(const CConfig& srcConfig)
{
int i;

ItemArray.SetSize(srcConfig.ItemArray.Size);
for(i=0;i<ItemArray.Size;i++) ItemArray[i].Set(((CConfig)srcConfig).ItemArray[i]);
}

CConfig::~CConfig()
{
ItemArray.RemoveAll();
}

CConfig& CConfig::operator=(const CConfig& srcConfig)
{
int i;

ItemArray.SetSize(srcConfig.ItemArray.Size);
for(i=0;i<ItemArray.Size;i++) ItemArray[i]=((CConfig&)srcConfig).ItemArray[i];
return (*this);
}

void CConfig::Open(CString ConfigFileName)
{
FILE *hConfigFile;
CString LineString;
CConfig_Item Item;

hConfigFile=fopen((const char *)ConfigFileName, "rt");
if (hConfigFile == NULL)
	throw(CException(CException::CErrorTypeException, errno, "CConfig::Open"));

while (feof(hConfigFile) == 0)
	{
	LineString=CConfig::ReadFileLine(hConfigFile, 32768);
	if (LineString.Find('=') >= 0)
		{
		Item.Name=LineString.Left(LineString.Find('='));
		Item.Value=LineString.Mid(LineString.Find('=')+1);

		ItemArray.Add(Item);
		}
	}

fclose(hConfigFile);
}

void CConfig::Close()
{
ItemArray.RemoveAll();
}

int CConfig::GetItemArraySize()
{
return ItemArray.Size;
}

CString CConfig::GetItemName(int Order)
{
if ((Order < 0)||(Order >= ItemArray.Size))
	throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "CConfig::GetItemName"));

return ItemArray[Order].Name;
}

CString CConfig::GetItemValue(CString ItemName)
{
int i;

for(i=0;i<ItemArray.Size;i++)
	{
	if (ItemArray[i].Name == ItemName)
		return ItemArray[i].Value;
	}

throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "CConfig::GetItemValue"));
}

int CConfig::IsExistItemName(CString ItemName)
{
int i;

for(i=0;i<ItemArray.Size;i++)
	{
	if (ItemArray[i].Name == ItemName) return 1;
	}

return 0;
}

CString CConfig::GetItemValue(int Order)
{
if ((Order < 0)||(Order >= ItemArray.Size))
	throw(CException(CException::CErrorTypeException, CException::CIllegalParameter, "CConfig::GetItemValue"));

return ItemArray[Order].Value;
}

CString CConfig::ReadFileLine(FILE *hFile, int MaxLength)
{
CString Line;
int ch;

Line="";
while ((ch=fgetc(hFile)) != EOF)
	{
	if ((ch == 13)||(ch == 10))
		{
		// CR+LF̉sR[hȂ̂
		if (ch == 13)
			{
			ch=fgetc(hFile);
			if (ch != 10) ungetc(ch, hFile); // LFł͂Ȃ̂Ŗ߂
			}
		break;
		}

	Line+=(char)ch;
	if (Line.Length >= MaxLength) break;
	}

return Line;
}

#ifdef CCLASSDEBUG
void CConfig::SelfTest()
{
printf("Self testing CConfig class ..\n");

{
FILE *fout;
CConfig Config;
int i;

fout=fopen("configtest.txt", "wt");
fprintf(fout, "One=1\r\n");
fprintf(fout, "Two=22\r\n");
fprintf(fout, "Three=333\r\n");
fprintf(fout, "Four=4444\r\n");
fprintf(fout, "Five=55555\r\n");
fprintf(fout, "Six=666666\r\n");
fprintf(fout, "Seven=7777777\r\n");
fprintf(fout, "Eight=88888888\r\n");
fprintf(fout, "Nine=999999999\r\n");
fclose(fout);

Config.Open("configtest.txt");
printf("  Number of configuration items .. %i\n", Config.GetItemArraySize());
printf("  Dumping item names .. ");
	for(i=0;i<Config.GetItemArraySize();i++)
		printf("[%s] ", (const char *)Config.GetItemName(i));
printf("\n");
printf("  Dumping item values .. ");
	for(i=0;i<Config.GetItemArraySize();i++)
		printf("[%s] ", (const char *)Config.GetItemValue(i));
printf("\n");
}

printf("Self testing CConfig() completed.\n");
}
#endif
